/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.history.provider.impl;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.item.impl.LaunchAccessValidator;
import com.epam.ta.reportportal.core.item.impl.history.param.HistoryRequestParams;
import com.epam.ta.reportportal.core.item.impl.history.provider.HistoryProvider;
import com.epam.ta.reportportal.core.item.utils.DefaultLaunchFilterProvider;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.dao.UserFilterRepository;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.entity.item.history.TestItemHistory;
import com.epam.ta.reportportal.entity.launch.Launch;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class FilterBaselineHistoryProvider
implements HistoryProvider {
    private final LaunchRepository launchRepository;
    private final LaunchAccessValidator launchAccessValidator;
    private final TestItemRepository testItemRepository;
    private final UserFilterRepository filterRepository;

    @Autowired
    public FilterBaselineHistoryProvider(LaunchRepository launchRepository, LaunchAccessValidator launchAccessValidator, TestItemRepository testItemRepository, UserFilterRepository filterRepository) {
        this.launchRepository = launchRepository;
        this.launchAccessValidator = launchAccessValidator;
        this.testItemRepository = testItemRepository;
        this.filterRepository = filterRepository;
    }

    @Override
    public Page<TestItemHistory> provide(Queryable filter, Pageable pageable, HistoryRequestParams historyRequestParams, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, boolean usingHash) {
        return historyRequestParams.getFilterParams().map(filterParams -> {
            UserFilter userFilter = (UserFilter)this.filterRepository.findByIdAndProjectId(filterParams.getFilterId(), projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_FILTER_NOT_FOUND_IN_PROJECT, new Object[]{filterParams.getFilterId(), projectDetails.getProjectName()}));
            Pair<Queryable, Pageable> launchQueryablePair = DefaultLaunchFilterProvider.createDefaultLaunchQueryablePair(projectDetails, userFilter, filterParams.getLaunchesLimit());
            return this.getItemsWithLaunchesFiltering(launchQueryablePair, (Pair<Queryable, Pageable>)Pair.of((Object)filter, (Object)pageable), projectDetails, user, (HistoryRequestParams.FilterParams)filterParams, historyRequestParams, usingHash);
        }).orElseGet(() -> Page.empty((Pageable)pageable));
    }

    private Page<TestItemHistory> getItemsWithLaunchesFiltering(Pair<Queryable, Pageable> launchQueryablePair, Pair<Queryable, Pageable> testItemQueryablePair, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, HistoryRequestParams.FilterParams filterParams, HistoryRequestParams historyRequestParams, boolean usingHash) {
        return historyRequestParams.getHistoryType().filter(HistoryRequestParams.HistoryTypeEnum.LINE::equals).map(type -> historyRequestParams.getLaunchId().map(launchId -> {
            Launch launch = (Launch)this.launchRepository.findById(launchId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId}));
            this.launchAccessValidator.validate(launch.getId(), projectDetails, user);
            return this.testItemRepository.loadItemsHistoryPage(filterParams.isLatest(), (Queryable)launchQueryablePair.getLeft(), (Queryable)testItemQueryablePair.getLeft(), (Pageable)launchQueryablePair.getRight(), (Pageable)testItemQueryablePair.getRight(), projectDetails.getProjectId(), launch.getName(), historyRequestParams.getHistoryDepth(), usingHash);
        }).orElseGet(() -> Page.empty((Pageable)((Pageable)testItemQueryablePair.getRight())))).orElseGet(() -> this.testItemRepository.loadItemsHistoryPage(filterParams.isLatest(), (Queryable)launchQueryablePair.getLeft(), (Queryable)testItemQueryablePair.getLeft(), (Pageable)launchQueryablePair.getRight(), (Pageable)testItemQueryablePair.getRight(), projectDetails.getProjectId(), historyRequestParams.getHistoryDepth(), usingHash));
    }
}

