/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.filter.updater;

import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.item.impl.filter.updater.FilterUpdater;
import com.epam.ta.reportportal.dao.IssueTypeRepository;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssueTypeConditionReplacer
implements FilterUpdater {
    private final IssueTypeRepository issueTypeRepository;

    @Autowired
    public IssueTypeConditionReplacer(IssueTypeRepository issueTypeRepository) {
        this.issueTypeRepository = issueTypeRepository;
    }

    @Override
    public void update(Queryable filter) {
        List issueTypeLocators = filter.getFilterConditions().stream().map(ConvertibleCondition::getAllConditions).flatMap(Collection::stream).filter(c -> "issueType".equals(c.getSearchCriteria()) && !c.isNegative() && Condition.IN.equals((Object)c.getCondition())).map(FilterCondition::getValue).flatMap(c -> Stream.of(c.split(","))).collect(Collectors.toList());
        String issueTypeIdsString = this.issueTypeRepository.getIssueTypeIdsByLocators(issueTypeLocators).stream().map(String::valueOf).collect(Collectors.joining(","));
        FilterCondition oldIssueTypeCondition = new FilterCondition(Condition.IN, false, null, "issueType");
        FilterCondition issueTypeIdCondition = new FilterCondition(Condition.IN, false, issueTypeIdsString, "issueTypeId");
        filter.replaceSearchCriteria(oldIssueTypeCondition, issueTypeIdCondition);
    }
}

