/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.identity;

import com.epam.ta.reportportal.core.item.identity.TestCaseHashGenerator;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.google.api.client.util.Lists;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class TestCaseHashGeneratorImpl
implements TestCaseHashGenerator {
    private final TestItemRepository testItemRepository;

    public TestCaseHashGeneratorImpl(TestItemRepository testItemRepository) {
        this.testItemRepository = testItemRepository;
    }

    @Override
    public Integer generate(TestItem item, List<Long> parentIds, Long projectId) {
        return this.prepare(item, parentIds, projectId).hashCode();
    }

    private String prepare(TestItem item, List<Long> parentIds, Long projectId) {
        ArrayList elements = Lists.newArrayList();
        elements.add(projectId.toString());
        this.getPathNames(parentIds).stream().filter(StringUtils::isNotEmpty).forEach(elements::add);
        elements.add(item.getName());
        item.getParameters().stream().map(parameter -> (String)(!Strings.isNullOrEmpty((String)parameter.getKey()) ? parameter.getKey() + "=" : "") + parameter.getValue()).forEach(elements::add);
        return String.join((CharSequence)";", elements);
    }

    private List<String> getPathNames(List<Long> parentIds) {
        return this.testItemRepository.findAllById(parentIds).stream().sorted(Comparator.comparingLong(TestItem::getItemId)).map(TestItem::getName).collect(Collectors.toList());
    }
}

