/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.util;

import com.epam.reportportal.extension.bugtracking.BtsExtension;
import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.core.integration.util.BasicIntegrationServiceImpl;
import com.epam.ta.reportportal.core.integration.util.property.BtsProperties;
import com.epam.ta.reportportal.core.plugin.PluginBox;
import com.epam.ta.reportportal.dao.IntegrationRepository;
import com.epam.ta.reportportal.entity.enums.AuthType;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.jasypt.util.text.BasicTextEncryptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BtsIntegrationService
extends BasicIntegrationServiceImpl {
    private final BasicTextEncryptor basicTextEncryptor;

    @Autowired
    public BtsIntegrationService(IntegrationRepository integrationRepository, PluginBox pluginBox, BasicTextEncryptor basicTextEncryptor) {
        super(integrationRepository, pluginBox);
        this.basicTextEncryptor = basicTextEncryptor;
    }

    @Override
    public Map<String, Object> retrieveCreateParams(String integrationType, Map<String, Object> integrationParams) {
        BusinessRule.expect(integrationParams, MapUtils::isNotEmpty).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"No integration params provided"});
        HashMap resultParams = Maps.newHashMapWithExpectedSize((int)BtsProperties.values().length);
        resultParams.put(BtsProperties.PROJECT.getName(), BtsProperties.PROJECT.getParam(integrationParams).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"BTS project is not specified."})));
        resultParams.put(BtsProperties.URL.getName(), BtsProperties.URL.getParam(integrationParams).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"BTS url is not specified."})));
        String authName = BtsProperties.AUTH_TYPE.getParam(integrationParams).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"Auth type is not specified."}));
        this.retrieveAuthParams(integrationParams, resultParams, authName);
        resultParams.put(BtsProperties.AUTH_TYPE.getName(), authName);
        return resultParams;
    }

    @Override
    public Map<String, Object> retrieveUpdatedParams(String integrationType, Map<String, Object> integrationParams) {
        HashMap resultParams = Maps.newHashMapWithExpectedSize((int)integrationParams.size());
        BtsProperties.URL.getParam(integrationParams).ifPresent(url -> resultParams.put(BtsProperties.URL.getName(), url));
        BtsProperties.PROJECT.getParam(integrationParams).ifPresent(url -> resultParams.put(BtsProperties.PROJECT.getName(), url));
        BtsProperties.AUTH_TYPE.getParam(integrationParams).ifPresent(authName -> {
            this.retrieveAuthParams(integrationParams, resultParams, (String)authName);
            resultParams.put(BtsProperties.AUTH_TYPE.getName(), authName);
        });
        Optional.ofNullable(integrationParams.get("defectFormFields")).ifPresent(defectFormFields -> resultParams.put("defectFormFields", defectFormFields));
        return resultParams;
    }

    @Override
    public boolean checkConnection(Integration integration) {
        BtsExtension extension = this.pluginBox.getInstance(integration.getType().getName(), BtsExtension.class).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{Suppliers.formattedSupplier((String)"Could not find plugin with name '{}'.", (Object[])new Object[]{integration.getType().getName()}).get()}));
        BusinessRule.expect((Object)extension.testConnection(integration), BooleanUtils::isTrue).verify(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"Connection refused."});
        return true;
    }

    private Map<String, Object> retrieveAuthParams(Map<String, Object> integrationParams, Map<String, Object> resultParams, String authName) {
        AuthType authType = (AuthType)AuthType.findByName((String)authName).orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_AUTHENTICATION_TYPE, new Object[]{authName}));
        if (AuthType.BASIC.equals((Object)authType)) {
            resultParams.put(BtsProperties.USER_NAME.getName(), BtsProperties.USER_NAME.getParam(integrationParams).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"Username value is not specified"})));
            String encryptedPassword = this.basicTextEncryptor.encrypt(BtsProperties.PASSWORD.getParam(integrationParams).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"Password value is not specified"})));
            resultParams.put(BtsProperties.PASSWORD.getName(), encryptedPassword);
        } else if (AuthType.OAUTH.equals((Object)authType)) {
            String encryptedAccessKey = this.basicTextEncryptor.encrypt(BtsProperties.OAUTH_ACCESS_KEY.getParam(integrationParams).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"AccessKey value is not specified"})));
            resultParams.put(BtsProperties.OAUTH_ACCESS_KEY.getName(), encryptedAccessKey);
        } else {
            throw new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"Unsupported auth type for integration - " + authType.name()});
        }
        return resultParams;
    }
}

