/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.plugin.strategy;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.core.integration.plugin.PluginUploader;
import com.epam.ta.reportportal.core.integration.plugin.strategy.JarPluginUploader;
import com.epam.ta.reportportal.core.integration.plugin.strategy.JsonPluginUploader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PluginUploaderFactory {
    private final Map<String, PluginUploader> uploads = new HashMap<String, PluginUploader>();

    @Autowired
    public PluginUploaderFactory(JarPluginUploader jarPluginUploader, JsonPluginUploader jsonPluginUploader) {
        this.uploads.put("jar", jarPluginUploader);
        this.uploads.put("zip", jarPluginUploader);
        this.uploads.put("json", jsonPluginUploader);
    }

    public PluginUploader getUploader(String extension) {
        return Optional.ofNullable(this.uploads.get(extension)).orElseThrow(() -> new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{"Unsupported extension type: " + extension}));
    }
}

