/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.plugin.strategy;

import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.core.integration.plugin.PluginUploader;
import com.epam.ta.reportportal.dao.IntegrationTypeRepository;
import com.epam.ta.reportportal.entity.enums.IntegrationGroupEnum;
import com.epam.ta.reportportal.entity.enums.PluginTypeEnum;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import com.epam.ta.reportportal.entity.integration.IntegrationTypeDetails;
import com.epam.ta.reportportal.util.JsonSchemaValidator;
import com.epam.ta.reportportal.ws.converter.builders.IntegrationTypeBuilder;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.ValidationMessage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JsonPluginUploader
implements PluginUploader {
    private final IntegrationTypeRepository integrationTypeRepository;
    private final ObjectMapper objectMapper;
    private final JsonSchemaValidator schemaValidator;

    @Autowired
    public JsonPluginUploader(IntegrationTypeRepository integrationTypeRepository, ObjectMapper objectMapper, JsonSchemaValidator schemaValidator) {
        this.integrationTypeRepository = integrationTypeRepository;
        this.objectMapper = objectMapper;
        this.schemaValidator = schemaValidator;
    }

    @Override
    public IntegrationType uploadPlugin(String fileName, InputStream inputStream) throws IOException {
        try {
            Map<String, Object> manifest = this.parseManifest(inputStream);
            this.validateManifest(manifest);
            return (IntegrationType)this.integrationTypeRepository.save((Object)this.buildIntegrationType(manifest));
        }
        catch (ConstraintViolationException e) {
            throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)e.getCause().getMessage(), (Supplier[])new Supplier[0])});
        }
        catch (IOException e) {
            throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Manifest file '{}' read error: {}", (Object[])new Object[]{fileName, e.getMessage()})});
        }
    }

    private Map<String, Object> parseManifest(InputStream input) throws IOException {
        return (Map)this.objectMapper.readValue(input, (TypeReference)new TypeReference<Map<String, Object>>(this){});
    }

    private void validateManifest(Map<String, Object> manifest) throws IOException {
        String schemaLocation = Optional.ofNullable(manifest.get("$schema")).orElseThrow(() -> new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Schema location is not specified in manifest", (Supplier[])new Supplier[0])})).toString();
        Set<ValidationMessage> validationMessages = this.schemaValidator.validate(schemaLocation, this.objectMapper.valueToTree(manifest));
        if (!validationMessages.isEmpty()) {
            throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Manifest file validation error: {}", (Object[])new Object[]{validationMessages})});
        }
    }

    private IntegrationType buildIntegrationType(Map<String, Object> manifest) {
        IntegrationTypeDetails details = new IntegrationTypeDetails();
        details.setDetails(manifest);
        String name = Optional.ofNullable(manifest.get("id")).map(Object::toString).orElseThrow(() -> new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Plugin id is not specified in manifest file", (Supplier[])new Supplier[0])}));
        IntegrationGroupEnum group = Optional.ofNullable(manifest.get("group")).map(Object::toString).flatMap(IntegrationGroupEnum::findByName).orElse(IntegrationGroupEnum.OTHER);
        return new IntegrationTypeBuilder().setName(name).setIntegrationGroup(group).setDetails(details).setEnabled(true).setPluginType(PluginTypeEnum.REMOTE).get();
    }
}

