/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.plugin.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.activity.PluginUploadedEvent;
import com.epam.ta.reportportal.core.integration.plugin.CreatePluginHandler;
import com.epam.ta.reportportal.core.integration.plugin.PluginUploader;
import com.epam.ta.reportportal.core.integration.plugin.strategy.PluginUploaderFactory;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import com.epam.ta.reportportal.model.EntryCreatedRS;
import com.epam.ta.reportportal.model.activity.PluginActivityResource;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CreatePluginHandlerImpl
implements CreatePluginHandler {
    private final PluginUploaderFactory pluginUploaderFactory;
    private final ApplicationEventPublisher applicationEventPublisher;

    @Autowired
    public CreatePluginHandlerImpl(PluginUploaderFactory pluginUploaderFactory, ApplicationEventPublisher applicationEventPublisher) {
        this.pluginUploaderFactory = pluginUploaderFactory;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public EntryCreatedRS uploadPlugin(MultipartFile pluginFile, ReportPortalUser user) {
        EntryCreatedRS entryCreatedRS;
        block8: {
            String newPluginFileName = pluginFile.getOriginalFilename();
            String extension = FilenameUtils.getExtension((String)newPluginFileName);
            BusinessRule.expect((Object)newPluginFileName, StringUtils::isNotBlank).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"File name should be not empty."});
            InputStream inputStream = pluginFile.getInputStream();
            try {
                PluginUploader uploader = this.pluginUploaderFactory.getUploader(extension);
                IntegrationType integrationType = uploader.uploadPlugin(newPluginFileName, inputStream);
                PluginActivityResource pluginActivityResource = new PluginActivityResource();
                pluginActivityResource.setId(integrationType.getId());
                pluginActivityResource.setName(integrationType.getName());
                this.applicationEventPublisher.publishEvent((Object)new PluginUploadedEvent(pluginActivityResource, user.getUserId(), user.getUsername()));
                entryCreatedRS = new EntryCreatedRS(integrationType.getId());
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{"Error during file stream retrieving"});
                }
            }
            inputStream.close();
        }
        return entryCreatedRS;
    }
}

