/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.bts.handler.GetBugTrackingSystemHandler;
import com.epam.ta.reportportal.core.integration.GetIntegrationHandler;
import com.epam.ta.reportportal.core.integration.util.IntegrationService;
import com.epam.ta.reportportal.core.integration.util.validator.IntegrationValidator;
import com.epam.ta.reportportal.dao.IntegrationRepository;
import com.epam.ta.reportportal.dao.IntegrationTypeRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.enums.IntegrationGroupEnum;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.model.integration.IntegrationResource;
import com.epam.ta.reportportal.ws.converter.converters.IntegrationConverter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class GetIntegrationHandlerImpl
implements GetIntegrationHandler {
    private final Map<String, IntegrationService> integrationServiceMapping;
    private final IntegrationService basicIntegrationService;
    private final IntegrationRepository integrationRepository;
    private final IntegrationTypeRepository integrationTypeRepository;
    private final ProjectRepository projectRepository;
    private final GetBugTrackingSystemHandler getBugTrackingSystemHandler;

    @Autowired
    public GetIntegrationHandlerImpl(@Qualifier(value="integrationServiceMapping") Map<String, IntegrationService> integrationServiceMapping, @Qualifier(value="basicIntegrationServiceImpl") IntegrationService integrationService, IntegrationRepository integrationRepository, IntegrationTypeRepository integrationTypeRepository, ProjectRepository projectRepository, GetBugTrackingSystemHandler getBugTrackingSystemHandler) {
        this.integrationServiceMapping = integrationServiceMapping;
        this.basicIntegrationService = integrationService;
        this.integrationRepository = integrationRepository;
        this.integrationTypeRepository = integrationTypeRepository;
        this.projectRepository = projectRepository;
        this.getBugTrackingSystemHandler = getBugTrackingSystemHandler;
    }

    @Override
    public IntegrationResource getProjectIntegrationById(Long integrationId, String projectName) {
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        Integration integration = (Integration)this.integrationRepository.findByIdAndProjectId(integrationId, project.getId()).orElseThrow(() -> new ReportPortalException(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{integrationId}));
        return IntegrationConverter.TO_INTEGRATION_RESOURCE.apply(integration);
    }

    @Override
    public IntegrationResource getGlobalIntegrationById(Long integrationId) {
        Integration integration = (Integration)this.integrationRepository.findGlobalById(integrationId).orElseThrow(() -> new ReportPortalException(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{integrationId}));
        return IntegrationConverter.TO_INTEGRATION_RESOURCE.apply(integration);
    }

    @Override
    public Optional<Integration> getEnabledByProjectIdOrGlobalAndIntegrationGroup(Long projectId, IntegrationGroupEnum integrationGroup) {
        List<Long> integrationTypeIds = this.integrationTypeRepository.findAllByIntegrationGroup(integrationGroup).stream().map(IntegrationType::getId).collect(Collectors.toList());
        List integrations = this.integrationRepository.findAllByProjectIdAndInIntegrationTypeIds(projectId, integrationTypeIds);
        if (!CollectionUtils.isEmpty((Collection)integrations)) {
            return integrations.stream().filter(integration -> integration.getType().isEnabled() && integration.isEnabled()).findFirst();
        }
        return this.getGlobalIntegrationByIntegrationTypeIds(integrationTypeIds);
    }

    @Override
    public Integration getEnabledBtsIntegration(ReportPortalUser.ProjectDetails projectDetails, String url, String btsProject) {
        Project project = (Project)this.projectRepository.findById((Object)projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectDetails.getProjectName()}));
        Integration integration = this.getBugTrackingSystemHandler.getEnabledProjectIntegration(projectDetails, url, btsProject).orElseGet(() -> {
            Integration globalIntegration = this.getBugTrackingSystemHandler.getEnabledGlobalIntegration(url, btsProject).orElseThrow(() -> new ReportPortalException(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{url}));
            IntegrationValidator.validateProjectLevelIntegrationConstraints(project, globalIntegration);
            return globalIntegration;
        });
        this.validateIntegration(integration);
        return integration;
    }

    @Override
    public Integration getEnabledBtsIntegration(ReportPortalUser.ProjectDetails projectDetails, Long integrationId) {
        Project project = (Project)this.projectRepository.findById((Object)projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectDetails.getProjectName()}));
        Integration integration = this.getBugTrackingSystemHandler.getEnabledProjectIntegration(projectDetails, integrationId).orElseGet(() -> {
            Integration globalIntegration = this.getBugTrackingSystemHandler.getEnabledGlobalIntegration(integrationId).orElseThrow(() -> new ReportPortalException(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{integrationId}));
            IntegrationValidator.validateProjectLevelIntegrationConstraints(project, globalIntegration);
            return globalIntegration;
        });
        this.validateIntegration(integration);
        return integration;
    }

    @Override
    public Integration getEnabledBtsIntegration(Long integrationId) {
        Integration globalIntegration = this.getBugTrackingSystemHandler.getEnabledGlobalIntegration(integrationId).orElseThrow(() -> new ReportPortalException(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{integrationId}));
        return globalIntegration;
    }

    @Override
    public List<IntegrationResource> getGlobalIntegrations() {
        return this.integrationRepository.findAllGlobal().stream().map(IntegrationConverter.TO_INTEGRATION_RESOURCE).collect(Collectors.toList());
    }

    @Override
    public List<IntegrationResource> getGlobalIntegrations(String pluginName) {
        IntegrationType integrationType = (IntegrationType)this.integrationTypeRepository.findByName(pluginName).orElseThrow(() -> new ReportPortalException(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{pluginName}));
        return this.integrationRepository.findAllGlobalByType(integrationType).stream().map(IntegrationConverter.TO_INTEGRATION_RESOURCE).collect(Collectors.toList());
    }

    @Override
    public List<IntegrationResource> getProjectIntegrations(String projectName) {
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        return this.integrationRepository.findAllByProjectIdOrderByCreationDateDesc(project.getId()).stream().map(IntegrationConverter.TO_INTEGRATION_RESOURCE).collect(Collectors.toList());
    }

    @Override
    public List<IntegrationResource> getProjectIntegrations(String pluginName, String projectName) {
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        IntegrationType integrationType = (IntegrationType)this.integrationTypeRepository.findByName(pluginName).orElseThrow(() -> new ReportPortalException(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{pluginName}));
        return this.integrationRepository.findAllByProjectIdAndTypeOrderByCreationDateDesc(project.getId(), integrationType).stream().map(IntegrationConverter.TO_INTEGRATION_RESOURCE).collect(Collectors.toList());
    }

    @Override
    public boolean testConnection(Long integrationId, String projectName) {
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        Integration integration = this.integrationRepository.findByIdAndProjectId(integrationId, project.getId()).orElseGet(() -> (Integration)this.integrationRepository.findGlobalById(integrationId).orElseThrow(() -> new ReportPortalException(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{integrationId})));
        IntegrationService integrationService = this.integrationServiceMapping.getOrDefault(integration.getType().getName(), this.basicIntegrationService);
        return integrationService.checkConnection(integration);
    }

    @Override
    public boolean testConnection(Long integrationId) {
        Integration integration = (Integration)this.integrationRepository.findGlobalById(integrationId).orElseThrow(() -> new ReportPortalException(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{integrationId}));
        IntegrationService integrationService = this.integrationServiceMapping.getOrDefault(integration.getType().getName(), this.basicIntegrationService);
        return integrationService.checkConnection(integration);
    }

    private Optional<Integration> getGlobalIntegrationByIntegrationTypeIds(List<Long> integrationTypeIds) {
        return this.integrationRepository.findAllGlobalInIntegrationTypeIds(integrationTypeIds).stream().filter(integration -> integration.getType().isEnabled() && integration.isEnabled()).findFirst();
    }

    private void validateIntegration(Integration integration) {
        BusinessRule.expect((Object)integration, i -> integration.getType().isEnabled()).verify(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{Suppliers.formattedSupplier((String)"'{}' type integrations are disabled by Administrator", (Object[])new Object[]{integration.getType().getName()}).get()});
        BusinessRule.expect((Object)integration, Integration::isEnabled).verify(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{Suppliers.formattedSupplier((String)"Integration with ID = '{}' is disabled", (Object[])new Object[]{integration.getId()}).get()});
    }
}

