/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.filter.predefined;

import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.filter.predefined.PredefinedFilterBuilder;
import com.epam.ta.reportportal.core.filter.predefined.PredefinedFilterType;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.enums.TestItemTypeEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.project.ProjectInfo;
import com.epam.ta.reportportal.entity.user.User;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.Operator;

public final class PredefinedFilters {
    public static final Collection<TestItemTypeEnum> HAS_METHOD_OR_CLASS = Arrays.stream(TestItemTypeEnum.values()).filter(it -> {
        String name = it.name();
        return name.contains("METHOD") || name.contains("CLASS");
    }).collect(Collectors.toList());
    private static final Map<PredefinedFilterType, PredefinedFilterBuilder> FILTERS = ImmutableMap.builder().put((Object)PredefinedFilterType.COLLAPSED, (Object)new PredefinedFilterBuilder(){

        @Override
        public Queryable build(String[] params) {
            return Filter.builder().withTarget(TestItem.class).withCondition((ConvertibleCondition)new FilterCondition(Operator.OR, Condition.EQUALS, false, StatusEnum.FAILED.name(), "status")).withCondition((ConvertibleCondition)new FilterCondition(Operator.OR, Condition.IN, true, HAS_METHOD_OR_CLASS.stream().map(Enum::name).collect(Collectors.joining(",")), "type")).withCondition((ConvertibleCondition)new FilterCondition(Operator.OR, Condition.EXISTS, false, "true", "issueType")).build();
        }
    }).put((Object)PredefinedFilterType.USERS, (Object)new PredefinedFilterBuilder(){

        @Override
        public Queryable build(String[] params) {
            return Filter.builder().withTarget(User.class).withCondition((ConvertibleCondition)new FilterCondition(Operator.OR, Condition.CONTAINS, false, params[0], "user")).withCondition((ConvertibleCondition)new FilterCondition(Operator.OR, Condition.CONTAINS, false, params[0], "fullName")).withCondition((ConvertibleCondition)new FilterCondition(Operator.OR, Condition.CONTAINS, false, params[0], "email")).build();
        }
    }).put((Object)PredefinedFilterType.PROJECTS, (Object)new PredefinedFilterBuilder(){

        @Override
        public Queryable build(String[] params) {
            return Filter.builder().withTarget(ProjectInfo.class).withCondition((ConvertibleCondition)new FilterCondition(Operator.OR, Condition.CONTAINS, false, params[0], "name")).withCondition((ConvertibleCondition)new FilterCondition(Operator.OR, Condition.CONTAINS, false, params[0], "organization")).build();
        }
    }).put((Object)PredefinedFilterType.ACTIVITIES, (Object)new PredefinedFilterBuilder(){

        @Override
        public Queryable build(String[] params) {
            return Filter.builder().withTarget(Activity.class).withCondition((ConvertibleCondition)new FilterCondition(Operator.OR, Condition.CONTAINS, false, PredefinedFilters.normalizeSpaceSensitiveValue(params[0]), "eventName")).withCondition((ConvertibleCondition)new FilterCondition(Operator.OR, Condition.CONTAINS, false, params[0], "subjectType")).withCondition((ConvertibleCondition)new FilterCondition(Operator.OR, Condition.CONTAINS, false, params[0], "subjectName")).withCondition((ConvertibleCondition)new FilterCondition(Operator.OR, Condition.CONTAINS, false, PredefinedFilters.normalizeSpaceSensitiveValue(params[0]), "objectType")).withCondition((ConvertibleCondition)new FilterCondition(Operator.OR, Condition.CONTAINS, false, params[0], "objectName")).build();
        }
    }).build();

    private PredefinedFilters() {
    }

    public static boolean hasFilter(PredefinedFilterType type) {
        return FILTERS.containsKey((Object)type);
    }

    public static Queryable buildFilter(PredefinedFilterType type, String[] params) {
        PredefinedFilterBuilder builder = FILTERS.get((Object)type);
        return builder.buildFilter(params);
    }

    private static String normalizeSpaceSensitiveValue(String value) {
        String SPACES = "\\s";
        return value.replaceAll("\\s", "");
    }
}

