/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.filter.impl;

import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.querygen.CompositeFilter;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.filter.FilterOperation;
import com.epam.ta.reportportal.core.filter.SearchCriteriaService;
import com.epam.ta.reportportal.core.filter.predefined.PredefinedFilterType;
import com.epam.ta.reportportal.core.filter.predefined.PredefinedFilters;
import com.epam.ta.reportportal.model.SearchCriteria;
import com.epam.ta.reportportal.model.SearchCriteriaRQ;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jooq.Operator;
import org.springframework.stereotype.Service;

@Service
public class SearchCriteriaServiceImpl
implements SearchCriteriaService {
    private static final String PREDEFINED_FILTER = "predefinedFilter";

    @Override
    public Queryable createFilterBySearchCriteria(SearchCriteriaRQ searchCriteriaRQ, Class<?> target, PredefinedFilterType predefinedFilterType) {
        Filter filter = new Filter(target, (List)Lists.newArrayList());
        if (CollectionUtils.isEmpty(searchCriteriaRQ.getCriteriaList())) {
            return filter;
        }
        filter.withConditions(this.collectConditions(searchCriteriaRQ));
        Optional<SearchCriteria> predefinedFilter = this.getPredefinedFilterIfExist(searchCriteriaRQ);
        return predefinedFilter.isPresent() ? this.createCompositeFilter(predefinedFilterType, filter, predefinedFilter.get()) : filter;
    }

    private List<ConvertibleCondition> collectConditions(SearchCriteriaRQ searchCriteriaRQ) {
        return searchCriteriaRQ.getCriteriaList().stream().filter(criteria -> !PREDEFINED_FILTER.equalsIgnoreCase(criteria.getFilterKey())).map(this::mapCriteriaToCondition).collect(Collectors.toList());
    }

    private ConvertibleCondition mapCriteriaToCondition(SearchCriteria searchCriteria) {
        return (ConvertibleCondition)FilterOperation.fromString(searchCriteria.getOperation()).map(operation -> operation.getConditionBuilder().withSearchCriteria(searchCriteria.getFilterKey()).withValue(searchCriteria.getValue()).build()).orElseThrow(() -> new ReportPortalException(String.format("Can not convert operation type %s.", searchCriteria.getOperation())));
    }

    private Optional<SearchCriteria> getPredefinedFilterIfExist(SearchCriteriaRQ searchCriteriaRQ) {
        return searchCriteriaRQ.getCriteriaList().stream().filter(criteria -> PREDEFINED_FILTER.equalsIgnoreCase(criteria.getFilterKey())).findFirst();
    }

    private CompositeFilter createCompositeFilter(PredefinedFilterType predefinedFilterType, Filter filter, SearchCriteria predefinedFilter) {
        String[] params = new String[]{predefinedFilter.getValue()};
        Queryable activityPredefinedFilter = PredefinedFilters.buildFilter(predefinedFilterType, params);
        return new CompositeFilter(Operator.AND, new Queryable[]{filter, activityPredefinedFilter});
    }
}

