/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.filter;

import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import java.util.Arrays;
import java.util.Optional;

public enum FilterOperation {
    EQ(FilterCondition.builder().withCondition(Condition.EQUALS)),
    NE(FilterCondition.builder().withCondition(Condition.NOT_EQUALS)),
    CNT(FilterCondition.builder().withCondition(Condition.CONTAINS)),
    NON_CNT(FilterCondition.builder().withCondition(Condition.CONTAINS).withNegative(true)),
    BTW(FilterCondition.builder().withCondition(Condition.BETWEEN)),
    IN(FilterCondition.builder().withCondition(Condition.IN));

    private final FilterCondition.ConditionBuilder conditionBuilder;

    private FilterOperation(FilterCondition.ConditionBuilder conditionBuilder) {
        this.conditionBuilder = conditionBuilder;
    }

    public static Optional<FilterOperation> fromString(String string) {
        return Optional.ofNullable(string).flatMap(str -> Arrays.stream(FilterOperation.values()).filter(it -> it.name().equalsIgnoreCase((String)str)).findAny());
    }

    public FilterCondition.ConditionBuilder getConditionBuilder() {
        return this.conditionBuilder;
    }
}

