/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.multicaster;

import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.SimpleApplicationEventMulticaster;

public class DelegatingApplicationEventMulticaster
extends SimpleApplicationEventMulticaster {
    private final Set<Class<?>> errorHandlingEventTypes;

    public DelegatingApplicationEventMulticaster(Set<Class<?>> errorHandlingEventTypes) {
        this.errorHandlingEventTypes = errorHandlingEventTypes;
    }

    protected void invokeListener(ApplicationListener<?> listener, ApplicationEvent event) {
        Optional.ofNullable(this.getErrorHandler()).filter(h -> this.errorHandlingEventTypes.contains(event.getClass())).ifPresentOrElse(h -> {
            try {
                this.doInvokeListener(listener, event);
            }
            catch (Throwable err) {
                h.handleError(err);
            }
        }, () -> this.doInvokeListener(listener, event));
    }

    private void doInvokeListener(ApplicationListener listener, ApplicationEvent event) {
        try {
            listener.onApplicationEvent(event);
        }
        catch (ClassCastException ex) {
            String msg = ex.getMessage();
            if (msg == null || this.matchesClassCastMessage(msg, event.getClass())) {
                Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Non-matching event type for listener: " + String.valueOf(listener)), (Throwable)ex);
                }
            }
            throw ex;
        }
    }

    private boolean matchesClassCastMessage(String classCastMessage, Class<?> eventClass) {
        if (classCastMessage.startsWith(eventClass.getName())) {
            return true;
        }
        if (classCastMessage.startsWith(eventClass.toString())) {
            return true;
        }
        int moduleSeparatorIndex = classCastMessage.indexOf(47);
        return moduleSeparatorIndex != -1 && classCastMessage.startsWith(eventClass.getName(), moduleSeparatorIndex + 1);
    }
}

