/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.handler.launch;

import com.epam.ta.reportportal.core.events.activity.LaunchFinishedEvent;
import com.epam.ta.reportportal.core.events.handler.ConfigurableEventHandler;
import com.epam.ta.reportportal.core.launch.cluster.UniqueErrorAnalysisStarter;
import com.epam.ta.reportportal.core.launch.cluster.config.ClusterEntityContext;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class LaunchUniqueErrorAnalysisRunner
implements ConfigurableEventHandler<LaunchFinishedEvent, Map<String, String>> {
    private final UniqueErrorAnalysisStarter uniqueErrorAnalysisStarter;

    @Autowired
    public LaunchUniqueErrorAnalysisRunner(@Qualifier(value="uniqueErrorAnalysisStarter") UniqueErrorAnalysisStarter uniqueErrorAnalysisStarter) {
        this.uniqueErrorAnalysisStarter = uniqueErrorAnalysisStarter;
    }

    @Override
    public void handle(LaunchFinishedEvent launchFinishedEvent, Map<String, String> projectConfig) {
        boolean enabled = BooleanUtils.toBoolean((String)projectConfig.get(ProjectAttributeEnum.AUTO_UNIQUE_ERROR_ANALYZER_ENABLED.getAttribute()));
        if (enabled) {
            this.uniqueErrorAnalysisStarter.start(ClusterEntityContext.of(launchFinishedEvent.getId(), launchFinishedEvent.getProjectId()), projectConfig);
        }
    }
}

