/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.handler.launch;

import com.epam.reportportal.model.project.AnalyzerConfig;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.analyzer.auto.starter.LaunchAutoAnalysisStarter;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.analyze.AnalyzeItemsMode;
import com.epam.ta.reportportal.core.analyzer.config.StartLaunchAutoAnalysisConfig;
import com.epam.ta.reportportal.core.events.activity.LaunchFinishedEvent;
import com.epam.ta.reportportal.core.events.handler.ConfigurableEventHandler;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class LaunchAutoAnalysisRunner
implements ConfigurableEventHandler<LaunchFinishedEvent, Map<String, String>> {
    private final LaunchAutoAnalysisStarter autoAnalysisStarter;

    public LaunchAutoAnalysisRunner(LaunchAutoAnalysisStarter autoAnalysisStarter) {
        this.autoAnalysisStarter = autoAnalysisStarter;
    }

    @Override
    public void handle(LaunchFinishedEvent launchFinishedEvent, Map<String, String> projectConfig) {
        AnalyzerConfig analyzerConfig = AnalyzerUtils.getAnalyzerConfig(projectConfig);
        StartLaunchAutoAnalysisConfig config = StartLaunchAutoAnalysisConfig.of(launchFinishedEvent.getId(), analyzerConfig, Set.of(AnalyzeItemsMode.IGNORE_IMMEDIATE), launchFinishedEvent.getUser());
        this.autoAnalysisStarter.start(config);
    }
}

