/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.handler.item;

import com.epam.reportportal.model.project.AnalyzerConfig;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.events.activity.item.IssueResolvedEvent;
import com.epam.ta.reportportal.core.events.handler.ConfigurableEventHandler;
import com.epam.ta.reportportal.core.launch.cluster.ClusterGenerator;
import com.epam.ta.reportportal.core.launch.cluster.config.ClusterEntityContext;
import com.epam.ta.reportportal.core.launch.cluster.config.GenerateClustersConfig;
import com.epam.ta.reportportal.model.project.UniqueErrorConfig;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class TestItemUniqueErrorAnalysisRunner
implements ConfigurableEventHandler<IssueResolvedEvent, Map<String, String>> {
    private final ClusterGenerator clusterGenerator;

    public TestItemUniqueErrorAnalysisRunner(@Qualifier(value="uniqueErrorGenerator") ClusterGenerator clusterGenerator) {
        this.clusterGenerator = clusterGenerator;
    }

    @Override
    public void handle(IssueResolvedEvent event, Map<String, String> projectConfig) {
        UniqueErrorConfig uniqueErrorConfig = AnalyzerUtils.getUniqueErrorConfig(projectConfig);
        if (uniqueErrorConfig.isEnabled()) {
            GenerateClustersConfig clustersConfig = new GenerateClustersConfig();
            clustersConfig.setForUpdate(true);
            clustersConfig.setCleanNumbers(uniqueErrorConfig.isRemoveNumbers());
            AnalyzerConfig analyzerConfig = AnalyzerUtils.getAnalyzerConfig(projectConfig);
            clustersConfig.setAnalyzerConfig(analyzerConfig);
            ClusterEntityContext entityContext = ClusterEntityContext.of(event.getLaunchId(), event.getProjectId(), List.of(event.getItemId()));
            clustersConfig.setEntityContext(entityContext);
            this.clusterGenerator.generate(clustersConfig);
        }
    }
}

