/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.activity.util;

import com.epam.ta.reportportal.entity.activity.HistoryField;
import com.google.common.base.Strings;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ActivityDetailsUtil {
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String DESCRIPTION = "description";
    public static final String EMPTY_FIELD = "";
    public static final String TICKET_ID = "ticketId";
    public static final String LAUNCH_INACTIVITY = "launchInactivity";
    public static final String EMPTY_STRING = "";
    public static final String COMMENT = "comment";
    public static final String ISSUE_TYPE = "issueType";
    public static final String IGNORE_ANALYZER = "ignoreAnalyzer";
    public static final String EMAIL_STATUS = "emailEnabled";
    public static final String EMAIL_CASES = "emailCases";
    public static final String EMAIL_FROM = "from";
    public static final String ITEMS_COUNT = "itemsCount";
    public static final String CONTENT_FIELDS = "contentFields";
    public static final String WIDGET_OPTIONS = "widgetOptions";
    public static final String STATUS = "status";
    public static final String RELEVANT_ITEM = "relevantItem";
    public static final String ENABLED = "enabled";
    public static final String ITEM_IDS = "itemIds";
    public static final String LAUNCH_ID = "launchId";
    public static final String PATTERN_NAME = "patternName";
    public static final String RP_SUBJECT_NAME = "ReportPortal";

    private ActivityDetailsUtil() {
    }

    public static Optional<HistoryField> processName(String oldName, String newName) {
        if (!Strings.isNullOrEmpty((String)newName) && !oldName.equals(newName)) {
            return Optional.of(HistoryField.of((String)NAME, (String)oldName, (String)newName));
        }
        return Optional.empty();
    }

    public static Optional<HistoryField> processDescription(String oldDescription, String newDescription) {
        oldDescription = Strings.nullToEmpty((String)oldDescription);
        if (!(newDescription = Strings.nullToEmpty((String)newDescription)).equals(oldDescription)) {
            return Optional.of(HistoryField.of((String)DESCRIPTION, (String)oldDescription, (String)newDescription));
        }
        return Optional.empty();
    }

    public static Optional<HistoryField> processBoolean(String type, boolean previous, boolean current) {
        if (previous != current) {
            return Optional.of(HistoryField.of((String)type, (String)String.valueOf(previous), (String)String.valueOf(current)));
        }
        return Optional.empty();
    }

    public static Optional<HistoryField> processParameter(Map<String, String> oldConfig, Map<String, String> newConfig, String parameterName) {
        String before = oldConfig.get(parameterName);
        String after = newConfig.get(parameterName);
        if (after != null && !after.equals(before)) {
            return Optional.of(HistoryField.of((String)parameterName, (String)before, (String)after));
        }
        return Optional.empty();
    }

    public static boolean configEquals(Map<String, String> before, Map<String, String> after, String prefix) {
        Map<String, String> beforeJobConfig = ActivityDetailsUtil.extractConfigByPrefix(before, prefix);
        Map<String, String> afterJobConfig = ActivityDetailsUtil.extractConfigByPrefix(after, prefix);
        return beforeJobConfig.equals(afterJobConfig);
    }

    public static boolean configChanged(Map<String, String> before, Map<String, String> after, String prefix) {
        return !ActivityDetailsUtil.configEquals(before, after, prefix);
    }

    public static Map<String, String> extractConfigByPrefix(Map<String, String> config, String prefix) {
        return config.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(prefix)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

