/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.activity;

import com.epam.ta.reportportal.builder.ActivityBuilder;
import com.epam.ta.reportportal.core.events.ActivityEvent;
import com.epam.ta.reportportal.core.events.activity.AbstractEvent;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.entity.activity.ActivityAction;
import com.epam.ta.reportportal.entity.activity.EventAction;
import com.epam.ta.reportportal.entity.activity.EventObject;
import com.epam.ta.reportportal.entity.activity.EventPriority;
import com.epam.ta.reportportal.entity.activity.EventSubject;
import java.util.Objects;

public class ProjectCreatedEvent
extends AbstractEvent
implements ActivityEvent {
    private final Long projectId;
    private final String projectName;

    public ProjectCreatedEvent(Long userId, String userLogin, Long projectId, String projectName) {
        super(userId, userLogin);
        this.projectId = projectId;
        this.projectName = projectName;
    }

    @Override
    public Activity toActivity() {
        return new ActivityBuilder().addCreatedNow().addAction(EventAction.CREATE).addEventName(ActivityAction.CREATE_PROJECT.getValue()).addPriority(EventPriority.MEDIUM).addObjectId(this.projectId).addObjectName(this.projectName).addObjectType(EventObject.PROJECT).addProjectId(this.projectId).addSubjectId(this.getUserId()).addSubjectName(this.getUserLogin()).addSubjectType(Objects.isNull(this.getUserId()) ? EventSubject.APPLICATION : EventSubject.USER).get();
    }
}

