/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.activity;

import com.epam.ta.reportportal.builder.ActivityBuilder;
import com.epam.ta.reportportal.core.events.ActivityEvent;
import com.epam.ta.reportportal.core.events.activity.AroundEvent;
import com.epam.ta.reportportal.core.events.activity.util.ActivityDetailsUtil;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.entity.activity.ActivityAction;
import com.epam.ta.reportportal.entity.activity.EventAction;
import com.epam.ta.reportportal.entity.activity.EventObject;
import com.epam.ta.reportportal.entity.activity.EventPriority;
import com.epam.ta.reportportal.entity.activity.EventSubject;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import com.epam.ta.reportportal.model.activity.ProjectAttributesActivityResource;
import java.util.Map;
import java.util.stream.Stream;

public class ProjectAnalyzerConfigEvent
extends AroundEvent<ProjectAttributesActivityResource>
implements ActivityEvent {
    public ProjectAnalyzerConfigEvent() {
    }

    public ProjectAnalyzerConfigEvent(ProjectAttributesActivityResource before, ProjectAttributesActivityResource after, Long userId, String userLogin) {
        super(userId, userLogin, before, after);
    }

    @Override
    public Activity toActivity() {
        ProjectAttributesActivityResource before = (ProjectAttributesActivityResource)this.getBefore();
        ProjectAttributesActivityResource after = (ProjectAttributesActivityResource)this.getAfter();
        Map<String, String> oldConfig = before.getConfig();
        Map<String, String> newConfig = after.getConfig();
        ActivityBuilder activityBuilder = new ActivityBuilder().addCreatedNow().addAction(EventAction.UPDATE).addEventName(ActivityAction.UPDATE_ANALYZER.getValue()).addPriority(EventPriority.LOW).addObjectId(before.getProjectId()).addObjectName("analyzer").addObjectType(EventObject.PROJECT).addProjectId(before.getProjectId()).addSubjectId(this.getUserId()).addSubjectName(this.getUserLogin()).addSubjectType(EventSubject.USER);
        Stream.of(ProjectAttributeEnum.AUTO_ANALYZER_MODE, ProjectAttributeEnum.MIN_SHOULD_MATCH, ProjectAttributeEnum.SEARCH_LOGS_MIN_SHOULD_MATCH, ProjectAttributeEnum.NUMBER_OF_LOG_LINES, ProjectAttributeEnum.AUTO_ANALYZER_ENABLED, ProjectAttributeEnum.AUTO_UNIQUE_ERROR_ANALYZER_ENABLED, ProjectAttributeEnum.UNIQUE_ERROR_ANALYZER_REMOVE_NUMBERS, ProjectAttributeEnum.ALL_MESSAGES_SHOULD_MATCH).map(type -> ActivityDetailsUtil.processParameter(oldConfig, newConfig, type.getAttribute())).forEach(arg_0 -> ((ActivityBuilder)activityBuilder).addHistoryField(arg_0));
        return activityBuilder.get();
    }
}

