/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.activity;

import com.epam.ta.reportportal.builder.ActivityBuilder;
import com.epam.ta.reportportal.core.events.ActivityEvent;
import com.epam.ta.reportportal.core.events.activity.AbstractEvent;
import com.epam.ta.reportportal.core.events.activity.util.IntegrationActivityPriorityResolver;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.entity.activity.ActivityAction;
import com.epam.ta.reportportal.entity.activity.EventAction;
import com.epam.ta.reportportal.entity.activity.EventObject;
import com.epam.ta.reportportal.entity.activity.EventSubject;
import com.epam.ta.reportportal.entity.activity.HistoryField;
import com.epam.ta.reportportal.model.activity.IntegrationActivityResource;
import java.util.Optional;

public class IntegrationDeletedEvent
extends AbstractEvent
implements ActivityEvent {
    private IntegrationActivityResource integrationActivityResource;

    public IntegrationDeletedEvent() {
    }

    public IntegrationDeletedEvent(IntegrationActivityResource integrationActivityResource, Long userId, String userLogin) {
        super(userId, userLogin);
        this.integrationActivityResource = integrationActivityResource;
    }

    public IntegrationActivityResource getIntegrationActivityResource() {
        return this.integrationActivityResource;
    }

    public void setIntegrationActivityResource(IntegrationActivityResource integrationActivityResource) {
        this.integrationActivityResource = integrationActivityResource;
    }

    @Override
    public Activity toActivity() {
        return new ActivityBuilder().addCreatedNow().addAction(EventAction.DELETE).addEventName(ActivityAction.DELETE_INTEGRATION.getValue()).addPriority(IntegrationActivityPriorityResolver.resolvePriority(this.integrationActivityResource)).addObjectId(this.integrationActivityResource.getId()).addObjectName(this.integrationActivityResource.getTypeName()).addObjectType(EventObject.INTEGRATION).addProjectId(this.integrationActivityResource.getProjectId()).addSubjectId(this.getUserId()).addSubjectName(this.getUserLogin()).addSubjectType(EventSubject.USER).addHistoryField(Optional.of(HistoryField.of((String)"name", (String)this.integrationActivityResource.getName(), null))).get();
    }
}

