/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.dashboard.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.dashboard.UpdateDashboardHandler;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.DashboardUpdatedEvent;
import com.epam.ta.reportportal.core.events.activity.WidgetDeletedEvent;
import com.epam.ta.reportportal.core.widget.content.remover.WidgetContentRemover;
import com.epam.ta.reportportal.dao.DashboardRepository;
import com.epam.ta.reportportal.dao.DashboardWidgetRepository;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.dashboard.Dashboard;
import com.epam.ta.reportportal.entity.dashboard.DashboardWidget;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.model.activity.DashboardActivityResource;
import com.epam.ta.reportportal.model.dashboard.AddWidgetRq;
import com.epam.ta.reportportal.model.dashboard.UpdateDashboardRQ;
import com.epam.ta.reportportal.ws.converter.builders.DashboardBuilder;
import com.epam.ta.reportportal.ws.converter.converters.DashboardConverter;
import com.epam.ta.reportportal.ws.converter.converters.WidgetConverter;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class UpdateDashboardHandlerImpl
implements UpdateDashboardHandler {
    private static final int DELETE_WIDGET_COUNT_THRESHOLD = 1;
    private final DashboardWidgetRepository dashboardWidgetRepository;
    private final DashboardRepository dashboardRepository;
    private final WidgetContentRemover widgetContentRemover;
    private final WidgetRepository widgetRepository;
    private final MessageBus messageBus;

    @Autowired
    public UpdateDashboardHandlerImpl(DashboardRepository dashboardRepository, @Qualifier(value="delegatingStateContentRemover") WidgetContentRemover widgetContentRemover, MessageBus messageBus, DashboardWidgetRepository dashboardWidgetRepository, WidgetRepository widgetRepository) {
        this.dashboardRepository = dashboardRepository;
        this.widgetContentRemover = widgetContentRemover;
        this.messageBus = messageBus;
        this.dashboardWidgetRepository = dashboardWidgetRepository;
        this.widgetRepository = widgetRepository;
    }

    @Override
    public OperationCompletionRS updateDashboard(ReportPortalUser.ProjectDetails projectDetails, UpdateDashboardRQ rq, Long dashboardId, ReportPortalUser user) {
        Dashboard dashboard = (Dashboard)this.dashboardRepository.findByIdAndProjectId(dashboardId, projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.DASHBOARD_NOT_FOUND_IN_PROJECT, new Object[]{dashboardId, projectDetails.getProjectName()}));
        DashboardActivityResource before = DashboardConverter.TO_ACTIVITY_RESOURCE.apply(dashboard);
        if (!dashboard.getName().equals(rq.getName())) {
            BusinessRule.expect((Object)this.dashboardRepository.existsByNameAndProjectId(rq.getName(), projectDetails.getProjectId()), BooleanUtils::isFalse).verify(ErrorType.RESOURCE_ALREADY_EXISTS, new Object[]{rq.getName()});
        }
        dashboard = new DashboardBuilder(dashboard).addUpdateRq(rq).get();
        this.dashboardRepository.save((Object)dashboard);
        this.messageBus.publishActivity(new DashboardUpdatedEvent(before, DashboardConverter.TO_ACTIVITY_RESOURCE.apply(dashboard), user.getUserId(), user.getUsername()));
        return new OperationCompletionRS("Dashboard with ID = '" + dashboard.getId() + "' successfully updated");
    }

    @Override
    public OperationCompletionRS addWidget(Long dashboardId, ReportPortalUser.ProjectDetails projectDetails, AddWidgetRq rq, ReportPortalUser user) {
        Dashboard dashboard = (Dashboard)this.dashboardRepository.findByIdAndProjectId(dashboardId, projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.DASHBOARD_NOT_FOUND_IN_PROJECT, new Object[]{dashboardId, projectDetails.getProjectName()}));
        Set dashboardWidgets = dashboard.getWidgets();
        this.validateWidgetBeforeAddingToDashboard(rq, dashboard, dashboardWidgets);
        Widget widget = (Widget)this.widgetRepository.findByIdAndProjectId(rq.getAddWidget().getWidgetId(), projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.WIDGET_NOT_FOUND_IN_PROJECT, new Object[]{rq.getAddWidget().getWidgetId(), projectDetails.getProjectName()}));
        boolean isCreatedOnDashboard = CollectionUtils.isEmpty((Collection)widget.getDashboardWidgets());
        DashboardWidget dashboardWidget = WidgetConverter.toDashboardWidget(rq.getAddWidget(), dashboard, widget, isCreatedOnDashboard);
        this.dashboardWidgetRepository.save((Object)dashboardWidget);
        return new OperationCompletionRS("Widget with ID = '" + widget.getId() + "' was successfully added to the dashboard with ID = '" + dashboard.getId() + "'");
    }

    private void validateWidgetBeforeAddingToDashboard(AddWidgetRq rq, Dashboard dashboard, Set<DashboardWidget> dashboardWidgets) {
        BusinessRule.expect((Object)dashboardWidgets.stream().anyMatch(dashboardWidget -> StringUtils.equals((CharSequence)dashboardWidget.getWidgetName(), (CharSequence)rq.getAddWidget().getName())), BooleanUtils::isFalse).verify(ErrorType.DASHBOARD_UPDATE_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Widget with name = '{}' is already added to the dashboard with name = '{}'", (Object[])new Object[]{rq.getAddWidget().getName(), dashboard.getName()})});
        BusinessRule.expect((Object)dashboardWidgets.stream().map(dw -> dw.getId().getWidgetId()).anyMatch(widgetId -> widgetId.equals(rq.getAddWidget().getWidgetId())), BooleanUtils::isFalse).verify(ErrorType.DASHBOARD_UPDATE_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Widget with ID = '{}' is already added to the dashboard with ID = '{}'", (Object[])new Object[]{rq.getAddWidget().getWidgetId(), dashboard.getId()})});
    }

    @Override
    public OperationCompletionRS removeWidget(Long widgetId, Long dashboardId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        Dashboard dashboard = (Dashboard)this.dashboardRepository.findByIdAndProjectId(dashboardId, projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.DASHBOARD_NOT_FOUND_IN_PROJECT, new Object[]{dashboardId, projectDetails.getProjectName()}));
        Widget widget = (Widget)this.widgetRepository.findByIdAndProjectId(widgetId, projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.WIDGET_NOT_FOUND_IN_PROJECT, new Object[]{widgetId, projectDetails.getProjectName()}));
        if (this.shouldDelete(widget)) {
            OperationCompletionRS result = this.deleteWidget(widget);
            this.messageBus.publishActivity(new WidgetDeletedEvent(WidgetConverter.TO_ACTIVITY_RESOURCE.apply(widget), user.getUserId(), user.getUsername()));
            return result;
        }
        DashboardWidget toRemove = dashboard.getWidgets().stream().filter(dashboardWidget -> widget.getId().equals(dashboardWidget.getId().getWidgetId())).findFirst().orElseThrow(() -> new ReportPortalException(ErrorType.WIDGET_NOT_FOUND_IN_DASHBOARD, new Object[]{widgetId, dashboardId}));
        this.dashboardWidgetRepository.delete((Object)toRemove);
        return new OperationCompletionRS("Widget with ID = '" + widget.getId() + "' was successfully removed from the dashboard with ID = '" + dashboard.getId() + "'");
    }

    private boolean shouldDelete(Widget widget) {
        return this.dashboardWidgetRepository.countAllByWidgetId(widget.getId()) <= 1;
    }

    private OperationCompletionRS deleteWidget(Widget widget) {
        this.widgetContentRemover.removeContent(widget);
        this.dashboardWidgetRepository.deleteAll((Iterable)widget.getDashboardWidgets());
        this.widgetRepository.delete((Object)widget);
        return new OperationCompletionRS("Widget with ID = '" + widget.getId() + "' was successfully deleted from the system.");
    }
}

