/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs.utils;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.core.configs.security.ApiKeyAuthenticationProvider;
import com.epam.ta.reportportal.core.configs.security.JwtCustomAuthenticationProvider;
import io.micrometer.common.util.StringUtils;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationManagerResolver;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.oauth2.jwt.JwtDecoder;

public class CustomAuthenticationManagerResolver
implements AuthenticationManagerResolver<HttpServletRequest> {
    private final ApiKeyAuthenticationProvider apiKeyAuthenticationProvider;
    private final JwtCustomAuthenticationProvider jwtCustomAuthenticationProvider;
    private final JwtDecoder jwtDecoder;

    public CustomAuthenticationManagerResolver(ApiKeyAuthenticationProvider apiKeyAuthenticationProvider, JwtCustomAuthenticationProvider jwtCustomAuthenticationProvider, JwtDecoder jwtDecoder) {
        this.apiKeyAuthenticationProvider = apiKeyAuthenticationProvider;
        this.jwtCustomAuthenticationProvider = jwtCustomAuthenticationProvider;
        this.jwtDecoder = jwtDecoder;
    }

    public AuthenticationManager resolve(HttpServletRequest request) {
        if (this.isJwt(request)) {
            return new ProviderManager(new AuthenticationProvider[]{this.jwtCustomAuthenticationProvider});
        }
        return new ProviderManager(new AuthenticationProvider[]{this.apiKeyAuthenticationProvider});
    }

    private boolean isJwt(HttpServletRequest request) {
        boolean isJwt;
        try {
            this.jwtDecoder.decode(CustomAuthenticationManagerResolver.getBearerValue(request));
            isJwt = true;
        }
        catch (Exception e) {
            isJwt = false;
        }
        return isJwt;
    }

    private static String getBearerValue(HttpServletRequest request) {
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null && authHeader.toLowerCase().startsWith("bearer")) {
            String token = authHeader.substring(7);
            if (StringUtils.isEmpty((String)token)) {
                throw new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Bearer token"});
            }
            return token;
        }
        throw new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Bearer token"});
    }
}

