/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs.security;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.auth.basic.DatabaseUserDetailsService;
import java.time.Instant;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.jwt.BadJwtException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.server.resource.InvalidBearerTokenException;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthenticationToken;
import org.springframework.util.Assert;

public class JwtCustomAuthenticationProvider
implements AuthenticationProvider {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final JwtDecoder jwtDecoder;
    private final DatabaseUserDetailsService userDetailsService;

    public JwtCustomAuthenticationProvider(JwtDecoder jwtDecoder, DatabaseUserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
        Assert.notNull((Object)jwtDecoder, (String)"jwtDecoder cannot be null");
        this.jwtDecoder = jwtDecoder;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        BearerTokenAuthenticationToken bearer = (BearerTokenAuthenticationToken)authentication;
        Jwt jwt = this.getJwt(bearer);
        String username = (String)jwt.getClaim("user_name");
        BusinessRule.expect((Object)this.isValid(jwt), BooleanUtils::isTrue).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"User token expired"});
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
        UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
        authToken.setDetails(authentication.getDetails());
        return authToken;
    }

    private Jwt getJwt(BearerTokenAuthenticationToken bearer) {
        try {
            return this.jwtDecoder.decode(bearer.getToken());
        }
        catch (BadJwtException failed) {
            this.logger.debug((Object)"Failed to authenticate since the JWT was invalid");
            throw new InvalidBearerTokenException(failed.getMessage(), (Throwable)failed);
        }
        catch (JwtException failed) {
            throw new AuthenticationServiceException(failed.getMessage(), (Throwable)failed);
        }
    }

    public boolean supports(Class<?> authentication) {
        return BearerTokenAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public boolean isValid(Jwt token) {
        return Instant.now().isBefore(Objects.requireNonNull(Objects.requireNonNull(token).getExpiresAt()));
    }
}

