/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs.security;

import com.epam.ta.reportportal.auth.ApiKeyUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.configs.security.ApiKeyReportPortalUserConverter;
import com.epam.ta.reportportal.dao.ApiKeyRepository;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.user.ApiKey;
import jakarta.xml.bind.DatatypeConverter;
import java.time.LocalDate;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthenticationToken;
import org.springframework.stereotype.Component;

@Component
public class ApiKeyAuthenticationProvider
implements AuthenticationProvider {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Converter<ReportPortalUser, ? extends AbstractAuthenticationToken> authenticationConverter = new ApiKeyReportPortalUserConverter();
    @Autowired
    private ApiKeyRepository apiKeyRepository;
    @Autowired
    private UserRepository userRepository;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        BearerTokenAuthenticationToken bearer = (BearerTokenAuthenticationToken)authentication;
        String apiToken = (String)bearer.getPrincipal();
        String hashedKey = DatatypeConverter.printHexBinary((byte[])DigestUtils.sha3_256((String)apiToken));
        ApiKey apiKey = this.apiKeyRepository.findByHash(hashedKey);
        if (ApiKeyUtils.validateToken(apiToken) && this.apiKeyRepository.findByHash(hashedKey) != null) {
            return (Authentication)this.userRepository.findReportPortalUser(apiKey.getUserId()).filter(ReportPortalUser::isEnabled).map(user -> {
                LocalDate today = LocalDate.now();
                if (apiKey.getLastUsedAt() == null || !apiKey.getLastUsedAt().equals(today)) {
                    this.apiKeyRepository.updateLastUsedAt(apiKey.getId(), hashedKey, today);
                }
                return user;
            }).map(arg_0 -> this.authenticationConverter.convert(arg_0)).map(authToken -> {
                if (authToken.getDetails() == null) {
                    authToken.setDetails(bearer.getDetails());
                }
                return authToken;
            }).orElseThrow();
        }
        throw new AuthenticationCredentialsNotFoundException("Invalid access token");
    }

    public boolean supports(Class<?> authentication) {
        return BearerTokenAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

