/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs.resource;

import com.epam.ta.reportportal.entity.ItemAttribute;
import com.epam.ta.reportportal.ws.converter.resource.handler.attribute.ItemAttributeType;
import com.epam.ta.reportportal.ws.converter.resource.handler.attribute.ResourceAttributeHandler;
import com.epam.ta.reportportal.ws.converter.resource.handler.attribute.launch.LaunchResourceAttributeLogger;
import com.epam.ta.reportportal.ws.converter.resource.handler.attribute.launch.LaunchResourceAttributeUpdater;
import com.epam.ta.reportportal.ws.converter.resource.handler.attribute.launch.LaunchResourceMetadataAttributeUpdater;
import com.epam.ta.reportportal.ws.converter.resource.handler.attribute.matcher.ItemAttributeTypeMatcher;
import com.epam.ta.reportportal.ws.converter.resource.handler.attribute.matcher.PredicateItemAttributeTypeMatcher;
import com.epam.ta.reportportal.ws.converter.resource.handler.attribute.resolver.ItemAttributeTypeResolver;
import com.epam.ta.reportportal.ws.converter.resource.handler.attribute.resolver.ItemAttributeTypeResolverDelegate;
import com.epam.ta.reportportal.ws.reporting.LaunchResource;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ResourceAttributeHandlerConfig {
    @Bean
    public ResourceAttributeHandler<LaunchResource> launchResourceAttributeUpdater() {
        return new LaunchResourceAttributeUpdater();
    }

    @Bean
    public ResourceAttributeHandler<LaunchResource> launchResourceMetadataAttributeUpdater() {
        return new LaunchResourceMetadataAttributeUpdater(Set.of("rp.cluster.lastRun"));
    }

    @Bean
    public ResourceAttributeHandler<LaunchResource> unresolvedAttributesLaunchLogger() {
        return new LaunchResourceAttributeLogger("Attributes with unresolved type: ");
    }

    @Bean
    public ItemAttributeTypeMatcher systemAttributeTypePredicateMatcher() {
        return new PredicateItemAttributeTypeMatcher(ItemAttribute::isSystem, ItemAttributeType.SYSTEM);
    }

    @Bean
    public ItemAttributeTypeMatcher publicAttributeTypePredicateMatcher() {
        return new PredicateItemAttributeTypeMatcher(it -> it.isSystem() == false, ItemAttributeType.PUBLIC);
    }

    @Bean
    public ItemAttributeTypeResolver itemAttributeTypeResolver() {
        return new ItemAttributeTypeResolverDelegate(List.of(this.publicAttributeTypePredicateMatcher(), this.systemAttributeTypePredicateMatcher()));
    }

    @Bean
    public Map<ItemAttributeType, ResourceAttributeHandler<LaunchResource>> attributeUpdaterMapping() {
        return ImmutableMap.builder().put((Object)ItemAttributeType.PUBLIC, this.launchResourceAttributeUpdater()).put((Object)ItemAttributeType.SYSTEM, this.launchResourceMetadataAttributeUpdater()).put((Object)ItemAttributeType.UNRESOLVED, this.unresolvedAttributesLaunchLogger()).build();
    }
}

