/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs.rabbit;

import com.epam.ta.reportportal.core.configs.Conditions;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={Conditions.NotTestCondition.class})
public class BackgroundProcessingConfiguration {
    public static final String LOG_MESSAGE_SAVING_QUEUE_NAME = "log_message_saving";
    public static final String LOG_MESSAGE_SAVING_ROUTING_KEY = "log_message_saving";
    public static final String PROCESSING_EXCHANGE_NAME = "processing";

    @Bean
    Queue logMessageSavingQueue() {
        return new Queue("log_message_saving");
    }

    @Bean
    DirectExchange exchangeProcessing() {
        return new DirectExchange(PROCESSING_EXCHANGE_NAME);
    }

    @Bean
    Binding bindingSavingLogs(@Qualifier(value="logMessageSavingQueue") Queue queue, @Qualifier(value="exchangeProcessing") DirectExchange exchange) {
        return BindingBuilder.bind((Queue)queue).to(exchange).with("log_message_saving");
    }
}

