/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.reportportal.extension.classloader.ReportPortalResourceLoader;
import com.epam.ta.reportportal.core.configs.Conditions;
import com.epam.ta.reportportal.job.CleanExpiredCreationBidsJob;
import com.epam.ta.reportportal.job.FlushingDataJob;
import com.epam.ta.reportportal.job.InterruptBrokenLaunchesJob;
import jakarta.inject.Named;
import java.time.Duration;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.scheduling.quartz.SimpleTriggerFactoryBean;
import org.springframework.scheduling.quartz.SpringBeanJobFactory;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@Conditional(value={Conditions.NotTestCondition.class})
@EnableConfigurationProperties(value={QuartzProperties.class})
public class SchedulerConfiguration {
    @Autowired
    List<Trigger> listOfTrigger;
    @Autowired
    private QuartzProperties quartzProperties;
    @Autowired
    private AutowireCapableBeanFactory context;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private ReportPortalResourceLoader resourceLoader;

    @Bean
    @Primary
    public SchedulerFactoryBean schedulerFactoryBean() {
        SchedulerFactoryBean scheduler = new SchedulerFactoryBean(this){

            public void setResourceLoader(ResourceLoader resourceLoader) {
                if (this.resourceLoader == null) {
                    super.setResourceLoader(resourceLoader);
                }
            }
        };
        scheduler.setApplicationContextSchedulerContextKey("applicationContext");
        scheduler.setOverwriteExistingJobs(true);
        scheduler.setResourceLoader((ResourceLoader)this.resourceLoader);
        scheduler.setQuartzProperties(this.quartzProperties.getQuartz());
        scheduler.setDataSource(this.dataSource);
        scheduler.setTransactionManager(this.transactionManager);
        scheduler.setAutoStartup(true);
        scheduler.setWaitForJobsToCompleteOnShutdown(true);
        scheduler.setJobFactory((JobFactory)this.beanJobFactory());
        if (null != this.listOfTrigger && !this.listOfTrigger.isEmpty()) {
            scheduler.setTriggers(this.listOfTrigger.toArray(new Trigger[this.listOfTrigger.size()]));
        }
        return scheduler;
    }

    @Bean
    public SpringBeanJobFactory beanJobFactory() {
        return new SpringBeanJobFactory(){

            protected Object createJobInstance(TriggerFiredBundle bundle) throws Exception {
                Object jobInstance = super.createJobInstance(bundle);
                SchedulerConfiguration.this.context.autowireBean(jobInstance);
                return jobInstance;
            }
        };
    }

    @Bean
    public SimpleTriggerFactoryBean interruptLaunchesTrigger(@Named(value="interruptLaunchesJobBean") JobDetail jobDetail, @Value(value="${com.ta.reportportal.job.interrupt.broken.launches.cron}") String interruptLaunchesCron) {
        return this.createTriggerDelayed(jobDetail, Duration.parse(interruptLaunchesCron).toMillis());
    }

    @Bean
    public SimpleTriggerFactoryBean cleanExpiredCreationBidsTrigger(@Named(value="cleanExpiredCreationBidsJobBean") JobDetail jobDetail, @Value(value="${com.ta.reportportal.job.clean.bids.cron}") String cleanBidsCron) {
        return this.createTrigger(jobDetail, Duration.parse(cleanBidsCron).toMillis());
    }

    @Bean
    @Profile(value={"demo"})
    public SimpleTriggerFactoryBean flushingDataTrigger(@Named(value="flushingDataJob") JobDetail jobDetail, @Value(value="${com.ta.reportportal.rp.flushing.time.cron}") String flushingCron) {
        return this.createTrigger(jobDetail, Duration.parse(flushingCron).toMillis());
    }

    @Bean(value={"interruptLaunchesJobBean"})
    public JobDetailFactoryBean interruptLaunchesJob() {
        return SchedulerConfiguration.createJobDetail(InterruptBrokenLaunchesJob.class);
    }

    @Bean(value={"cleanExpiredCreationBidsJobBean"})
    public JobDetailFactoryBean cleanExpiredCreationBidsJob() {
        return SchedulerConfiguration.createJobDetail(CleanExpiredCreationBidsJob.class);
    }

    @Bean
    @Profile(value={"demo"})
    @Named(value="flushingDataJob")
    public JobDetailFactoryBean flushingDataJob() {
        return SchedulerConfiguration.createJobDetail(FlushingDataJob.class);
    }

    public SimpleTriggerFactoryBean createTrigger(JobDetail jobDetail, long pollFrequencyMs) {
        SimpleTriggerFactoryBean factoryBean = new SimpleTriggerFactoryBean();
        factoryBean.setJobDetail(jobDetail);
        factoryBean.setStartDelay(0L);
        factoryBean.setRepeatInterval(pollFrequencyMs);
        factoryBean.setRepeatCount(-1);
        factoryBean.setMisfireInstruction(4);
        return factoryBean;
    }

    public SimpleTriggerFactoryBean createTriggerDelayed(JobDetail jobDetail, long pollFrequencyMs) {
        SimpleTriggerFactoryBean factoryBean = new SimpleTriggerFactoryBean();
        factoryBean.setJobDetail(jobDetail);
        factoryBean.setStartDelay(pollFrequencyMs);
        factoryBean.setRepeatInterval(pollFrequencyMs);
        factoryBean.setRepeatCount(-1);
        factoryBean.setMisfireInstruction(4);
        return factoryBean;
    }

    public static CronTriggerFactoryBean createCronTrigger(JobDetail jobDetail, String cronExpression) {
        CronTriggerFactoryBean factoryBean = new CronTriggerFactoryBean();
        factoryBean.setJobDetail(jobDetail);
        factoryBean.setCronExpression(cronExpression);
        factoryBean.setMisfireInstruction(1);
        return factoryBean;
    }

    public static JobDetailFactoryBean createJobDetail(Class<? extends Job> jobClass) {
        JobDetailFactoryBean factoryBean = new JobDetailFactoryBean();
        factoryBean.setJobClass(jobClass);
        factoryBean.setDurability(true);
        return factoryBean;
    }

    @ConfigurationProperties(value="spring.application")
    public static class QuartzProperties {
        private final Properties quartz = new Properties();

        public Properties getQuartz() {
            return this.quartz;
        }
    }
}

