/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.ta.reportportal.core.integration.plugin.PluginLoader;
import com.epam.ta.reportportal.core.integration.plugin.binary.PluginFilesProvider;
import com.epam.ta.reportportal.core.plugin.Pf4jPluginBox;
import com.epam.ta.reportportal.dao.IntegrationTypeRepository;
import com.epam.ta.reportportal.plugin.DetailManifestPluginDescriptorFinder;
import com.epam.ta.reportportal.plugin.Pf4jPluginManager;
import com.epam.ta.reportportal.plugin.ReportPortalExtensionFactory;
import jakarta.activation.FileTypeMap;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.pf4j.DefaultExtensionFinder;
import org.pf4j.DefaultPluginManager;
import org.pf4j.ExtensionFactory;
import org.pf4j.ExtensionFinder;
import org.pf4j.LegacyExtensionFinder;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginManager;
import org.pf4j.PluginStateListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.ConfigurableMimeFileTypeMap;

@Configuration
public class PluginConfiguration {
    @Autowired
    private AutowireCapableBeanFactory context;
    @Autowired
    private PluginLoader pluginLoader;
    @Autowired
    private IntegrationTypeRepository integrationTypeRepository;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Value(value="${rp.plugins.path}")
    private String pluginsPath;
    @Value(value="${rp.plugins.temp.path}")
    private String pluginsTempPath;
    @Value(value="${rp.plugins.resources.path}")
    private String pluginsResourcesPath;
    @Value(value="${rp.plugins.resources.public}")
    private String publicFolderQualifier;

    @Bean
    public Pf4jPluginBox pf4jPluginBox() throws IOException {
        return new Pf4jPluginManager(this.pluginsPath, this.pluginsTempPath, this.pluginsResourcesPath, this.pluginLoader, this.integrationTypeRepository, this.pluginManager(), this.context, this.applicationEventPublisher);
    }

    @Bean
    public PluginManager pluginManager() {
        return new DefaultPluginManager(new Path[]{Paths.get(this.pluginsPath, new String[0])}){

            protected PluginDescriptorFinder createPluginDescriptorFinder() {
                return PluginConfiguration.this.pluginDescriptorFinder();
            }

            protected ExtensionFactory createExtensionFactory() {
                return new ReportPortalExtensionFactory(PluginConfiguration.this.pluginsResourcesPath, (PluginManager)this, PluginConfiguration.this.context);
            }

            protected ExtensionFinder createExtensionFinder() {
                RpExtensionFinder extensionFinder = new RpExtensionFinder(this, (PluginManager)this);
                this.addPluginStateListener((PluginStateListener)extensionFinder);
                return extensionFinder;
            }

            class RpExtensionFinder
            extends DefaultExtensionFinder {
                private RpExtensionFinder(final 1 this$1, PluginManager pluginManager) {
                    super(pluginManager);
                    this.finders.clear();
                    this.finders.add(new LegacyExtensionFinder(this, pluginManager){

                        public Set<String> findClassNames(String pluginId) {
                            return Optional.ofNullable(super.findClassNames(pluginId)).orElseGet(Collections::emptySet);
                        }
                    });
                }
            }
        };
    }

    @Bean
    public PluginDescriptorFinder pluginDescriptorFinder() {
        return new DetailManifestPluginDescriptorFinder();
    }

    @Bean
    public FileTypeMap fileTypeMap() {
        return new ConfigurableMimeFileTypeMap();
    }

    @Bean
    public PluginFilesProvider pluginPublicFilesProvider() {
        return new PluginFilesProvider(this.pluginsResourcesPath, this.publicFolderQualifier, this.fileTypeMap(), this.integrationTypeRepository);
    }

    @Bean
    public PluginFilesProvider pluginFilesProvider() {
        return new PluginFilesProvider(this.pluginsResourcesPath, "", this.fileTypeMap(), this.integrationTypeRepository);
    }
}

