/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.reportportal.commons.template.TemplateEngine;
import com.epam.reportportal.commons.template.TemplateEngineProvider;
import com.epam.ta.reportportal.util.email.strategy.EmailNotificationStrategy;
import com.epam.ta.reportportal.util.email.strategy.EmailTemplate;
import com.epam.ta.reportportal.util.email.strategy.UserDeletionNotificationStrategy;
import com.epam.ta.reportportal.util.email.strategy.UserExpirationNotificationStrategy;
import com.epam.ta.reportportal.util.email.strategy.UserSelfDeletionNotificationStrategy;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class EmailConfiguration {
    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    public ThreadPoolTaskExecutor emailExecutorService(@Value(value="${rp.environment.variable.executor.pool.user-email.core}") Integer corePoolSize, @Value(value="${rp.environment.variable.executor.pool.user-email.max}") Integer maxPoolSize, @Value(value="${rp.environment.variable.executor.pool.user-email.queue}") Integer queueCapacity) {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(corePoolSize.intValue());
        threadPoolTaskExecutor.setMaxPoolSize(maxPoolSize.intValue());
        threadPoolTaskExecutor.setQueueCapacity(queueCapacity.intValue());
        threadPoolTaskExecutor.setAllowCoreThreadTimeOut(true);
        threadPoolTaskExecutor.setAwaitTerminationSeconds(20);
        threadPoolTaskExecutor.setThreadNamePrefix("email-sending-exec");
        return threadPoolTaskExecutor;
    }

    @Bean
    @Primary
    public TemplateEngine getTemplateEngine() {
        return new TemplateEngineProvider("/templates/email").get();
    }

    @Bean
    public Map<EmailTemplate, EmailNotificationStrategy> emailNotificationStrategyMapping() {
        return ImmutableMap.builder().put((Object)EmailTemplate.USER_EXPIRATION_NOTIFICATION, (Object)((EmailNotificationStrategy)this.applicationContext.getBean(UserExpirationNotificationStrategy.class))).put((Object)EmailTemplate.USER_DELETION_NOTIFICATION, (Object)((EmailNotificationStrategy)this.applicationContext.getBean(UserDeletionNotificationStrategy.class))).put((Object)EmailTemplate.USER_SELF_DELETION_NOTIFICATION, (Object)((EmailNotificationStrategy)this.applicationContext.getBean(UserSelfDeletionNotificationStrategy.class))).build();
    }
}

