/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
@EnableBatchProcessing
@ConditionalOnBean(name={"attachmentSizeConfig"})
public class BatchJobConfiguration {
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private Step attachmentSizeStep;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Bean
    public JobExecutionListener jobExecutionListener() {
        return new JobExecutionListener(){

            public void beforeJob(JobExecution jobExecution) {
            }

            public void afterJob(JobExecution jobExecution) {
                BatchJobConfiguration.this.jdbcTemplate.update("UPDATE project AS prj SET allocated_storage = (SELECT coalesce(sum(attachment.file_size), 0) FROM attachment WHERE project_id = prj.id)");
            }
        };
    }

    @Bean
    public Job job() {
        SimpleJobBuilder job = ((JobBuilder)((JobBuilder)new JobBuilder("attachmentSize", this.jobRepository).incrementer((JobParametersIncrementer)new RunIdIncrementer())).listener(this.jobExecutionListener())).start(this.attachmentSizeStep);
        return job.build();
    }
}

