/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.strategy;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.analyze.AnalyzeItemsMode;
import com.epam.ta.reportportal.core.analyzer.pattern.service.LaunchPatternAnalyzer;
import com.epam.ta.reportportal.core.analyzer.strategy.AbstractLaunchAnalysisStrategy;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.model.launch.AnalyzeLaunchRQ;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LaunchPatternAnalysisStrategy
extends AbstractLaunchAnalysisStrategy {
    private final LaunchPatternAnalyzer launchPatternAnalyzer;

    @Autowired
    public LaunchPatternAnalysisStrategy(ProjectRepository projectRepository, LaunchRepository launchRepository, LaunchPatternAnalyzer launchPatternAnalyzer) {
        super(projectRepository, launchRepository);
        this.launchPatternAnalyzer = launchPatternAnalyzer;
    }

    @Override
    public void analyze(AnalyzeLaunchRQ analyzeRQ, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        Set<AnalyzeItemsMode> analyzeItemsModes = analyzeRQ.getAnalyzeItemsModes().stream().map(AnalyzeItemsMode::fromString).collect(Collectors.toSet());
        BusinessRule.expect(analyzeItemsModes, CollectionUtils::isNotEmpty).verify(ErrorType.PATTERN_ANALYSIS_ERROR, new Object[]{"No analyze item mode specified."});
        Launch launch = (Launch)this.launchRepository.findById((Object)analyzeRQ.getLaunchId()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{analyzeRQ.getLaunchId()}));
        this.validateLaunch(launch, projectDetails);
        this.launchPatternAnalyzer.analyzeLaunch(launch, analyzeItemsModes);
    }
}

