/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.pattern.service.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerStatusCache;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.analyze.AnalyzeItemsMode;
import com.epam.ta.reportportal.core.analyzer.pattern.handler.ItemsPatternsAnalyzer;
import com.epam.ta.reportportal.core.analyzer.pattern.selector.condition.PatternConditionProviderChain;
import com.epam.ta.reportportal.core.analyzer.pattern.service.LaunchPatternAnalyzer;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class LaunchPatternAnalyzerImpl
implements LaunchPatternAnalyzer {
    public static final Logger LOGGER = LoggerFactory.getLogger(LaunchPatternAnalyzerImpl.class);
    private final Integer batchSize;
    private final TestItemRepository testItemRepository;
    private final PatternConditionProviderChain patternConditionProviderChain;
    private final AnalyzerStatusCache analyzerStatusCache;
    private final ItemsPatternsAnalyzer itemsPatternsAnalyzer;

    @Autowired
    public LaunchPatternAnalyzerImpl(@Value(value="${rp.environment.variable.pattern-analysis.batch-size}") Integer batchSize, TestItemRepository testItemRepository, PatternConditionProviderChain patternConditionProviderChain, AnalyzerStatusCache analyzerStatusCache, ItemsPatternsAnalyzer itemsPatternsAnalyzer) {
        this.batchSize = batchSize;
        this.testItemRepository = testItemRepository;
        this.patternConditionProviderChain = patternConditionProviderChain;
        this.analyzerStatusCache = analyzerStatusCache;
        this.itemsPatternsAnalyzer = itemsPatternsAnalyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyzeLaunch(Launch launch, Set<AnalyzeItemsMode> analyzeModes) {
        BusinessRule.expect(this.analyzerStatusCache.getStartedAnalyzers(launch.getId()), (Predicate)Predicates.not(started -> started.contains("patternAnalyzer"))).verify(ErrorType.PATTERN_ANALYSIS_ERROR, new Object[]{"Pattern analysis is still in progress."});
        this.analyzerStatusCache.analyzeStarted("patternAnalyzer", launch.getId(), launch.getProjectId());
        try {
            this.analyze(launch, this.buildItemsCondition(analyzeModes));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.analyzerStatusCache.analyzeFinished("patternAnalyzer", launch.getId());
        }
    }

    private void analyze(Launch launch, ConvertibleCondition itemCondition) {
        Filter filter = this.createItemFilter(itemCondition);
        int offset = 0;
        List itemIds = this.testItemRepository.selectIdsByFilter(launch.getId(), (Queryable)filter, this.batchSize.intValue(), offset);
        while (CollectionUtils.isNotEmpty((Collection)itemIds)) {
            this.itemsPatternsAnalyzer.analyze(launch.getProjectId(), launch.getId(), itemIds);
            itemIds = this.testItemRepository.selectIdsByFilter(launch.getId(), (Queryable)filter, this.batchSize.intValue(), offset += itemIds.size());
        }
        this.notifyAnalysisFinished(launch.getProjectId(), launch.getId());
    }

    private void notifyAnalysisFinished(long projectId, long launchId) {
        this.itemsPatternsAnalyzer.analyze(projectId, launchId, Collections.emptyList());
    }

    private ConvertibleCondition buildItemsCondition(Set<AnalyzeItemsMode> analyzeModes) {
        return this.patternConditionProviderChain.provideCondition(analyzeModes).orElseThrow(() -> new ReportPortalException(ErrorType.PATTERN_ANALYSIS_ERROR, new Object[]{"Unable to resolve item search condition"}));
    }

    private Filter createItemFilter(ConvertibleCondition commonItemCondition) {
        return Filter.builder().withTarget(TestItem.class).withCondition(commonItemCondition).build();
    }
}

