/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.pattern.service.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.core.analyzer.pattern.service.CreatePatternTemplateHandler;
import com.epam.ta.reportportal.dao.PatternTemplateRepository;
import com.epam.ta.reportportal.entity.pattern.PatternTemplate;
import com.epam.ta.reportportal.model.project.config.pattern.CreatePatternTemplateRQ;
import com.epam.ta.reportportal.ws.converter.builders.PatternTemplateBuilder;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CreatePatternTemplateHandlerImpl
implements CreatePatternTemplateHandler {
    protected final PatternTemplateRepository patternTemplateRepository;

    @Autowired
    public CreatePatternTemplateHandlerImpl(PatternTemplateRepository patternTemplateRepository) {
        this.patternTemplateRepository = patternTemplateRepository;
    }

    @Override
    public PatternTemplate createPatternTemplate(Long projectId, CreatePatternTemplateRQ createPatternTemplateRQ) {
        String name = StringUtils.trim((String)createPatternTemplateRQ.getName());
        BusinessRule.expect((Object)this.patternTemplateRepository.existsByProjectIdAndNameIgnoreCase(projectId, name), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.RESOURCE_ALREADY_EXISTS, new Object[]{name});
        PatternTemplate patternTemplate = new PatternTemplateBuilder().withCreateRequest(createPatternTemplateRQ).withName(name).withProjectId(projectId).get();
        return (PatternTemplate)this.patternTemplateRepository.save((Object)patternTemplate);
    }
}

