/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.pattern.selector.impl;

import com.epam.ta.reportportal.core.analyzer.pattern.selector.impl.AbstractPatternAnalysisSelector;
import com.epam.ta.reportportal.core.log.LogService;
import com.epam.ta.reportportal.dao.TestItemRepository;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StringPartPatternAnalysisSelector
extends AbstractPatternAnalysisSelector {
    @Autowired
    public StringPartPatternAnalysisSelector(TestItemRepository testItemRepository, LogService logService) {
        super(testItemRepository, logService);
    }

    @Override
    protected List<Long> getItemsWithMatches(String pattern, Set<Long> itemIds) {
        return this.logService.selectTestItemIdsByStringLogMessage(itemIds, 40000, pattern);
    }

    @Override
    protected List<Long> getItemsWithNestedStepsMatches(Long launchId, String pattern, List<Long> itemsWithNestedSteps) {
        return this.logService.selectTestItemIdsUnderByStringLogMessage(launchId, itemsWithNestedSteps, 40000, pattern);
    }
}

