/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.pattern.selector.impl;

import com.epam.ta.reportportal.core.analyzer.pattern.selector.PatternAnalysisSelector;
import com.epam.ta.reportportal.core.log.LogService;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractPatternAnalysisSelector
implements PatternAnalysisSelector {
    protected final TestItemRepository testItemRepository;
    protected final LogService logService;

    public AbstractPatternAnalysisSelector(TestItemRepository testItemRepository, LogService logService) {
        this.testItemRepository = testItemRepository;
        this.logService = logService;
    }

    protected abstract List<Long> getItemsWithMatches(String var1, Set<Long> var2);

    protected abstract List<Long> getItemsWithNestedStepsMatches(Long var1, String var2, List<Long> var3);

    @Override
    public List<Long> selectItemsByPattern(Long launchId, Collection<Long> itemIds, String pattern) {
        List itemsWithNestedSteps;
        HashSet sourceIds = Sets.newHashSet(itemIds);
        List<Long> itemsWithMatchedLogs = this.getItemsWithMatches(pattern, sourceIds);
        itemsWithMatchedLogs.forEach(sourceIds::remove);
        if (CollectionUtils.isNotEmpty((Collection)sourceIds) && CollectionUtils.isNotEmpty((Collection)(itemsWithNestedSteps = this.testItemRepository.selectIdsByHasDescendants((Collection)sourceIds)))) {
            List<Long> nestedStepsMatches = this.getItemsWithNestedStepsMatches(launchId, pattern, itemsWithNestedSteps);
            itemsWithMatchedLogs.addAll(nestedStepsMatches);
        }
        return itemsWithMatchedLogs;
    }
}

