/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.strategy.analyze;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.analyze.AnalyzeItemsCollector;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.item.TestItem;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IgnoreImmediateCollector
implements AnalyzeItemsCollector {
    protected static final String IMMEDIATE_AUTO_ANALYSIS = "immediateAutoAnalysis";
    private TestItemRepository testItemRepository;

    @Autowired
    public IgnoreImmediateCollector(TestItemRepository testItemRepository) {
        this.testItemRepository = testItemRepository;
    }

    @Override
    public List<Long> collectItems(Long projectId, Long launchId, ReportPortalUser user) {
        return this.testItemRepository.findItemsForAnalyze(launchId).stream().filter(ti -> ti.getItemResults().getIssue().getIgnoreAnalyzer() == false).filter(this::skipImmediateAA).map(TestItem::getItemId).collect(Collectors.toList());
    }

    private boolean skipImmediateAA(TestItem item) {
        return item.getAttributes().stream().filter(at -> at.getTestItem().getItemResults().getIssue().getIgnoreAnalyzer() == false).noneMatch(at -> IMMEDIATE_AUTO_ANALYSIS.equals(at.getKey()) && Boolean.parseBoolean(at.getValue()) && at.isSystem() != false);
    }
}

