/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.impl.preparer;

import com.epam.reportportal.model.analyzer.IndexLog;
import com.epam.reportportal.model.analyzer.IndexTestItem;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.analyzer.auto.impl.preparer.TestItemPreparerService;
import com.epam.ta.reportportal.core.log.LogService;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.LogLevel;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.jooq.enums.JTestItemTypeEnum;
import com.epam.ta.reportportal.util.Predicates;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class TestItemPreparerServiceImpl
implements TestItemPreparerService {
    private final TestItemRepository testItemRepository;
    private final LogService logService;

    public TestItemPreparerServiceImpl(TestItemRepository testItemRepository, LogService logService, LogRepository logRepository) {
        this.testItemRepository = testItemRepository;
        this.logService = logService;
    }

    @Override
    public List<IndexTestItem> prepare(Long launchId, Collection<TestItem> testItems) {
        List<IndexTestItem> itemsForIndexing = testItems.stream().filter(Predicates.ITEM_CAN_BE_INDEXED).map(AnalyzerUtils::fromTestItem).collect(Collectors.toList());
        return this.prepare(launchId, itemsForIndexing);
    }

    @Override
    public List<IndexTestItem> prepare(Long launchId) {
        List indexTestItems = this.testItemRepository.findIndexTestItemByLaunchId(launchId, List.of(JTestItemTypeEnum.STEP, JTestItemTypeEnum.BEFORE_METHOD, JTestItemTypeEnum.AFTER_METHOD));
        return this.prepare(launchId, indexTestItems);
    }

    private List<IndexTestItem> prepare(Long launchId, List<IndexTestItem> indexTestItemList) {
        Map<Long, List<IndexLog>> logsMapping = this.getLogsMapping(launchId, indexTestItemList.stream().map(IndexTestItem::getTestItemId).collect(Collectors.toList()));
        return indexTestItemList.stream().peek(indexTestItem -> Optional.ofNullable((List)logsMapping.get(indexTestItem.getTestItemId())).filter(CollectionUtils::isNotEmpty).map(HashSet::new).ifPresent(arg_0 -> ((IndexTestItem)indexTestItem).setLogs(arg_0))).filter(it -> CollectionUtils.isNotEmpty((Collection)it.getLogs())).collect(Collectors.toList());
    }

    private Map<Long, List<IndexLog>> getLogsMapping(Long launchId, List<Long> itemIds) {
        return this.logService.findAllIndexUnderTestItemByLaunchIdAndTestItemIdsAndLogLevelGte(launchId, itemIds, LogLevel.ERROR.toInt());
    }
}

