/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.impl;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.analyzer.auto.client.AnalyzerServiceClient;
import com.epam.ta.reportportal.core.analyzer.auto.client.model.SuggestInfo;
import com.epam.ta.reportportal.core.analyzer.auto.client.model.SuggestRq;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.analyzer.auto.impl.SuggestedItem;
import com.epam.ta.reportportal.core.item.impl.LaunchAccessValidator;
import com.epam.ta.reportportal.core.item.validator.state.TestItemValidator;
import com.epam.ta.reportportal.core.launch.GetLaunchHandler;
import com.epam.ta.reportportal.core.launch.cluster.GetClusterHandler;
import com.epam.ta.reportportal.core.log.LogService;
import com.epam.ta.reportportal.core.project.GetProjectHandler;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.cluster.Cluster;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.ws.converter.converters.LogConverter;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SuggestItemService {
    private static final int SUGGESTED_ITEMS_LOGS_LIMIT = 5;
    private final AnalyzerServiceClient analyzerServiceClient;
    private final GetProjectHandler getProjectHandler;
    private final GetLaunchHandler getLaunchHandler;
    private final GetClusterHandler getClusterHandler;
    private final LaunchAccessValidator launchAccessValidator;
    private final TestItemRepository testItemRepository;
    private final LogService logService;
    private final List<TestItemValidator> testItemValidators;

    @Autowired
    public SuggestItemService(AnalyzerServiceClient analyzerServiceClient, GetProjectHandler getProjectHandler, GetLaunchHandler getLaunchHandler, GetClusterHandler getClusterHandler, LaunchAccessValidator launchAccessValidator, TestItemRepository testItemRepository, LogService logService, List<TestItemValidator> testItemValidators) {
        this.analyzerServiceClient = analyzerServiceClient;
        this.getProjectHandler = getProjectHandler;
        this.getLaunchHandler = getLaunchHandler;
        this.getClusterHandler = getClusterHandler;
        this.launchAccessValidator = launchAccessValidator;
        this.testItemRepository = testItemRepository;
        this.logService = logService;
        this.testItemValidators = testItemValidators;
    }

    @Transactional(readOnly=true)
    public List<SuggestedItem> suggestItems(Long testItemId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        TestItem testItem = (TestItem)this.testItemRepository.findById((Object)testItemId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{testItemId}));
        this.validateTestItem(testItem);
        Launch launch = this.getLaunch(testItem.getLaunchId(), projectDetails, user);
        Project project = this.getProjectHandler.get(projectDetails);
        SuggestRq suggestRq = this.prepareSuggestRq(testItem, launch, project);
        return this.getSuggestedItems(suggestRq);
    }

    private void validateTestItem(TestItem testItem) {
        this.testItemValidators.forEach(v -> {
            if (!v.validate(testItem)) {
                throw new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{v.provide(testItem)});
            }
        });
    }

    @Transactional(readOnly=true)
    public List<SuggestedItem> suggestClusterItems(Long clusterId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        Cluster cluster = this.getClusterHandler.getById(clusterId);
        Launch launch = this.getLaunch(cluster.getLaunchId(), projectDetails, user);
        Project project = this.getProjectHandler.get(projectDetails);
        SuggestRq suggestRq = this.prepareSuggestRq(cluster, launch, project);
        return this.getSuggestedItems(suggestRq);
    }

    private Launch getLaunch(Long launchId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        Launch launch = this.getLaunchHandler.get(launchId);
        this.launchAccessValidator.validate(launch, projectDetails, user);
        return launch;
    }

    private SuggestRq prepareSuggestRq(TestItem testItem, Launch launch, Project project) {
        SuggestRq suggestRq = this.prepareSuggestRq(launch, project);
        suggestRq.setTestItemId(testItem.getItemId());
        suggestRq.setUniqueId(testItem.getUniqueId());
        suggestRq.setTestCaseHash(testItem.getTestCaseHash());
        suggestRq.setLogs(AnalyzerUtils.fromLogs(this.logService.findAllUnderTestItemByLaunchIdAndTestItemIdsAndLogLevelGte(launch.getId(), Collections.singletonList(testItem.getItemId()), 40000)));
        return suggestRq;
    }

    private SuggestRq prepareSuggestRq(Cluster cluster, Launch launch, Project project) {
        SuggestRq suggestRq = this.prepareSuggestRq(launch, project);
        suggestRq.setClusterId(cluster.getIndexId());
        return suggestRq;
    }

    private SuggestRq prepareSuggestRq(Launch launch, Project project) {
        SuggestRq suggestRq = new SuggestRq();
        suggestRq.setLaunchId(launch.getId());
        suggestRq.setLaunchName(launch.getName());
        suggestRq.setProject(project.getId());
        suggestRq.setAnalyzerConfig(AnalyzerUtils.getAnalyzerConfig(project));
        suggestRq.setLaunchNumber(launch.getNumber());
        return suggestRq;
    }

    private List<SuggestedItem> getSuggestedItems(SuggestRq suggestRq) {
        return this.analyzerServiceClient.searchSuggests(suggestRq).stream().map(this::prepareSuggestedItem).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private SuggestedItem prepareSuggestedItem(SuggestInfo suggestInfo) {
        TestItem relevantTestItem = this.testItemRepository.findById((Object)suggestInfo.getRelevantItem()).orElse(null);
        if (relevantTestItem == null) {
            return null;
        }
        SuggestedItem suggestedItem = new SuggestedItem();
        this.roundSuggestInfoMatchScore(suggestInfo);
        suggestedItem.setSuggestRs(suggestInfo);
        suggestedItem.setTestItemResource(TestItemConverter.TO_RESOURCE.apply(relevantTestItem));
        suggestedItem.setLogs(this.logService.findLatestUnderTestItemByLaunchIdAndTestItemIdsAndLogLevelGte(relevantTestItem.getLaunchId(), relevantTestItem.getItemId(), 40000, 5).stream().map(LogConverter.TO_RESOURCE).collect(Collectors.toSet()));
        return suggestedItem;
    }

    private void roundSuggestInfoMatchScore(SuggestInfo info) {
        float roundedMatchScore = Math.round(info.getMatchScore());
        info.setMatchScore(roundedMatchScore);
    }

    public OperationCompletionRS handleSuggestChoice(List<SuggestInfo> suggestInfos) {
        this.analyzerServiceClient.handleSuggestChoice(suggestInfos);
        return new OperationCompletionRS("User choice of suggested item was sent for handling to ML");
    }
}

