/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.impl;

import com.epam.reportportal.model.project.AnalyzerConfig;
import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.analyzer.auto.SearchLogService;
import com.epam.ta.reportportal.core.analyzer.auto.client.AnalyzerServiceClient;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.search.SearchCollectorFactory;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.search.SearchLogsMode;
import com.epam.ta.reportportal.core.log.LogService;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.PathName;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.log.LogFull;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.model.analyzer.SearchRq;
import com.epam.ta.reportportal.model.analyzer.SearchRs;
import com.epam.ta.reportportal.model.log.SearchLogRq;
import com.epam.ta.reportportal.model.log.SearchLogRs;
import com.epam.ta.reportportal.ws.converter.converters.IssueConverter;
import com.epam.ta.reportportal.ws.converter.converters.LogConverter;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SearchLogServiceImpl
implements SearchLogService {
    private final ProjectRepository projectRepository;
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private final LogService logService;
    private final AnalyzerServiceClient analyzerServiceClient;
    private final SearchCollectorFactory searchCollectorFactory;

    @Autowired
    public SearchLogServiceImpl(ProjectRepository projectRepository, LaunchRepository launchRepository, TestItemRepository testItemRepository, LogService logService, AnalyzerServiceClient analyzerServiceClient, SearchCollectorFactory searchCollectorFactory) {
        this.projectRepository = projectRepository;
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.logService = logService;
        this.analyzerServiceClient = analyzerServiceClient;
        this.searchCollectorFactory = searchCollectorFactory;
    }

    @Override
    public Iterable<SearchLogRs> search(Long itemId, SearchLogRq request, ReportPortalUser.ProjectDetails projectDetails) {
        Project project = (Project)this.projectRepository.findById((Object)projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectDetails.getProjectId()}));
        TestItem item = (TestItem)this.testItemRepository.findById((Object)itemId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{itemId}));
        Launch launch = (Launch)this.launchRepository.findById((Object)item.getLaunchId()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{item.getLaunchId()}));
        BusinessRule.expect((Object)item.getItemResults().getStatus(), (Predicate)Predicates.not((Predicate)Preconditions.statusIn((StatusEnum[])new StatusEnum[]{StatusEnum.IN_PROGRESS}))).verify(ErrorType.TEST_ITEM_IS_NOT_FINISHED, new Object[0]);
        return this.composeRequest(request, project, item, launch).map(searchRq -> this.processRequest(project.getId(), (SearchRq)searchRq)).orElse(Collections.emptyList());
    }

    private Optional<SearchRq> composeRequest(SearchLogRq request, Project project, TestItem item, Launch launch) {
        SearchLogsMode searchMode = SearchLogsMode.fromString(request.getSearchMode()).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{request.getSearchMode()}));
        SearchRq searchRq = new SearchRq();
        searchRq.setFilteredLaunchIds(this.searchCollectorFactory.getCollector(searchMode).collect(request.getFilterId(), launch));
        List<String> logMessages = this.logService.findMessagesByLaunchIdAndItemIdAndPathAndLevelGte(launch.getId(), item.getItemId(), item.getPath(), 40000);
        if (CollectionUtils.isEmpty(logMessages)) {
            return Optional.empty();
        }
        searchRq.setLogMessages(logMessages);
        AnalyzerConfig analyzerConfig = AnalyzerUtils.getAnalyzerConfig(project);
        searchRq.setAnalyzerConfig(analyzerConfig);
        searchRq.setLogLines(analyzerConfig.getNumberOfLogLines());
        searchRq.setItemId(item.getItemId());
        searchRq.setLaunchId(launch.getId());
        searchRq.setLaunchName(launch.getName());
        searchRq.setProjectId(project.getId());
        return Optional.of(searchRq);
    }

    private Collection<SearchLogRs> processRequest(Long projectId, SearchRq request) {
        List<SearchRs> searchRs = this.analyzerServiceClient.searchLogs(request);
        Map logIdMapping = searchRs.stream().collect(HashMap::new, (m, rs) -> m.put(rs.getLogId(), rs.getTestItemId()), Map::putAll);
        Map<Long, TestItem> testItemMapping = this.testItemRepository.findAllById(logIdMapping.values()).stream().collect(Collectors.toMap(TestItem::getItemId, item -> item));
        List<LogFull> foundLogs = this.logService.findAllById(logIdMapping.keySet());
        HashMap foundLogsMap = Maps.newHashMap();
        foundLogs.forEach(log -> Optional.ofNullable((Long)logIdMapping.get(log.getId())).ifPresent(itemId -> {
            foundLogsMap.computeIfPresent(itemId, (key, value) -> {
                value.getLogs().add(LogConverter.TO_LOG_ENTRY.apply((LogFull)log));
                return value;
            });
            foundLogsMap.computeIfAbsent(itemId, key -> this.composeResponse(testItemMapping, projectId, (Long)itemId, (LogFull)log));
        }));
        return foundLogsMap.values();
    }

    private SearchLogRs composeResponse(Map<Long, TestItem> testItemMapping, Long projectId, Long itemId, LogFull log) {
        TestItem testItem = Optional.ofNullable(testItemMapping.get(itemId)).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{itemId}));
        Long launchId = Optional.ofNullable(testItem.getLaunchId()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{testItem.getLaunchId()}));
        Launch launch = (Launch)this.launchRepository.findById((Object)launchId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId}));
        Map pathNameMapping = this.testItemRepository.selectPathNames(Collections.singletonList(testItem));
        SearchLogRs response = new SearchLogRs();
        response.setLaunchId(launch.getId());
        Optional.ofNullable((PathName)pathNameMapping.get(testItem.getItemId())).ifPresent(pathName -> response.setPathNames(TestItemConverter.PATH_NAME_TO_RESOURCE.apply((PathName)pathName)));
        response.setItemId(testItem.getItemId());
        response.setItemName(testItem.getName());
        response.setPath(testItem.getPath());
        response.setPatternTemplates(testItem.getPatternTemplateTestItems().stream().map(patternTemplateTestItem -> patternTemplateTestItem.getPatternTemplate().getName()).collect(Collectors.toSet()));
        response.setDuration(Optional.ofNullable(testItem.getItemResults().getDuration()).orElseGet(() -> this.getDuration(testItem)));
        response.setStatus(testItem.getItemResults().getStatus().name());
        TestItem itemWithStats = testItem;
        while (!itemWithStats.isHasStats()) {
            Long parentId = itemWithStats.getParentId();
            itemWithStats = (TestItem)this.testItemRepository.findById((Object)parentId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{parentId}));
        }
        response.setIssue(IssueConverter.TO_MODEL.apply(itemWithStats.getItemResults().getIssue()));
        response.setLogs(Lists.newArrayList((Object[])new SearchLogRs.LogEntry[]{LogConverter.TO_LOG_ENTRY.apply(log)}));
        return response;
    }

    private double getDuration(TestItem testItem) {
        return (double)ChronoUnit.MILLIS.between(testItem.getStartTime(), testItem.getItemResults().getEndTime()) / 1000.0;
    }
}

