/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.impl;

import com.epam.reportportal.model.analyzer.IndexLog;
import com.epam.reportportal.model.analyzer.IndexTestItem;
import com.epam.reportportal.model.project.AnalyzerConfig;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.log.LogFull;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.model.analyzer.RelevantItemInfo;
import com.epam.ta.reportportal.model.project.UniqueErrorConfig;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class AnalyzerUtils {
    private static final Function<LogFull, IndexLog> TO_INDEX_LOG = log -> {
        IndexLog indexLog = new IndexLog();
        indexLog.setLogId(log.getId());
        if (log.getLogLevel() != null) {
            indexLog.setLogLevel(log.getLogLevel().intValue());
        }
        indexLog.setMessage(log.getLogMessage());
        indexLog.setClusterId(log.getClusterId());
        return indexLog;
    };
    public static final Function<TestItem, RelevantItemInfo> TO_RELEVANT_ITEM_INFO = item -> {
        RelevantItemInfo relevantItemInfo = new RelevantItemInfo();
        relevantItemInfo.setItemId(String.valueOf(item.getItemId()));
        relevantItemInfo.setPath(item.getPath());
        relevantItemInfo.setLaunchId(String.valueOf(item.getLaunchId()));
        return relevantItemInfo;
    };

    private AnalyzerUtils() {
    }

    public static IndexTestItem fromTestItem(TestItem testItem) {
        LocalDateTime testItemStarTime = testItem.getStartTime() != null ? LocalDateTime.ofInstant(testItem.getStartTime(), ZoneId.systemDefault()) : null;
        IndexTestItem indexTestItem = new IndexTestItem();
        indexTestItem.setTestItemId(testItem.getItemId());
        indexTestItem.setTestItemName(testItem.getName());
        indexTestItem.setUniqueId(testItem.getUniqueId());
        indexTestItem.setStartTime(testItemStarTime);
        indexTestItem.setTestCaseHash(testItem.getTestCaseHash());
        if (testItem.getItemResults().getIssue() != null) {
            indexTestItem.setIssueTypeLocator(testItem.getItemResults().getIssue().getIssueType().getLocator());
            indexTestItem.setAutoAnalyzed(testItem.getItemResults().getIssue().getAutoAnalyzed().booleanValue());
        }
        return indexTestItem;
    }

    public static Set<IndexLog> fromLogs(List<LogFull> logs) {
        return logs.stream().filter(it -> StringUtils.isNotEmpty((CharSequence)it.getLogMessage())).map(TO_INDEX_LOG).collect(Collectors.toSet());
    }

    public static AnalyzerConfig getAnalyzerConfig(Project project) {
        Map configParameters = ProjectUtils.getConfigParameters((Set)project.getProjectAttributes());
        return AnalyzerUtils.getAnalyzerConfig(configParameters);
    }

    public static AnalyzerConfig getAnalyzerConfig(Map<String, String> configParameters) {
        AnalyzerConfig analyzerConfig = new AnalyzerConfig();
        analyzerConfig.setIsAutoAnalyzerEnabled(Boolean.valueOf(BooleanUtils.toBoolean((String)configParameters.get(ProjectAttributeEnum.AUTO_ANALYZER_ENABLED.getAttribute()))));
        analyzerConfig.setMinShouldMatch(Integer.valueOf(Optional.ofNullable(configParameters.get(ProjectAttributeEnum.MIN_SHOULD_MATCH.getAttribute())).orElse(ProjectAttributeEnum.MIN_SHOULD_MATCH.getDefaultValue())));
        analyzerConfig.setSearchLogsMinShouldMatch(Integer.valueOf(Optional.ofNullable(configParameters.get(ProjectAttributeEnum.SEARCH_LOGS_MIN_SHOULD_MATCH.getAttribute())).orElse(ProjectAttributeEnum.SEARCH_LOGS_MIN_SHOULD_MATCH.getDefaultValue())));
        analyzerConfig.setNumberOfLogLines(Integer.valueOf(Optional.ofNullable(configParameters.get(ProjectAttributeEnum.NUMBER_OF_LOG_LINES.getAttribute())).orElse(ProjectAttributeEnum.NUMBER_OF_LOG_LINES.getDefaultValue())));
        analyzerConfig.setIndexingRunning(BooleanUtils.toBoolean((String)configParameters.get(ProjectAttributeEnum.INDEXING_RUNNING.getAttribute())));
        analyzerConfig.setAnalyzerMode(configParameters.get(ProjectAttributeEnum.AUTO_ANALYZER_MODE.getAttribute()));
        analyzerConfig.setAllMessagesShouldMatch(BooleanUtils.toBoolean((String)configParameters.get(ProjectAttributeEnum.ALL_MESSAGES_SHOULD_MATCH.getAttribute())));
        return analyzerConfig;
    }

    public static UniqueErrorConfig getUniqueErrorConfig(Map<String, String> configParameters) {
        UniqueErrorConfig uniqueErrorConfig = new UniqueErrorConfig();
        uniqueErrorConfig.setEnabled(BooleanUtils.toBoolean((String)configParameters.get(ProjectAttributeEnum.AUTO_UNIQUE_ERROR_ANALYZER_ENABLED.getAttribute())));
        uniqueErrorConfig.setRemoveNumbers(BooleanUtils.toBoolean((String)configParameters.get(ProjectAttributeEnum.UNIQUE_ERROR_ANALYZER_REMOVE_NUMBERS.getAttribute())));
        return uniqueErrorConfig;
    }
}

