/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.impl;

import com.epam.reportportal.model.analyzer.IndexLaunch;
import com.epam.reportportal.model.project.AnalyzerConfig;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.core.analytics.DefectUpdateStatisticsService;
import com.epam.ta.reportportal.core.analyzer.auto.AnalyzerService;
import com.epam.ta.reportportal.core.analyzer.auto.client.AnalyzerServiceClient;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerStatusCache;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.analyzer.auto.impl.preparer.LaunchPreparerService;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.ItemIssueTypeDefinedEvent;
import com.epam.ta.reportportal.core.events.activity.LinkTicketEvent;
import com.epam.ta.reportportal.core.item.impl.IssueTypeHandler;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.AnalyzeMode;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.item.issue.IssueEntity;
import com.epam.ta.reportportal.entity.item.issue.IssueType;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.model.activity.TestItemActivityResource;
import com.epam.ta.reportportal.model.analyzer.AnalyzedItemRs;
import com.epam.ta.reportportal.model.analyzer.RelevantItemInfo;
import com.epam.ta.reportportal.ws.converter.builders.IssueEntityBuilder;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AnalyzerServiceImpl
implements AnalyzerService {
    private static final Logger LOGGER = LogManager.getLogger((String)AnalyzerServiceImpl.class.getName());
    private final AnalyzerStatusCache analyzerStatusCache;
    private final LaunchPreparerService launchPreparerService;
    private final AnalyzerServiceClient analyzerServicesClient;
    private final IssueTypeHandler issueTypeHandler;
    private final TestItemRepository testItemRepository;
    private final LaunchRepository launchRepository;
    private final MessageBus messageBus;
    private final Integer itemsBatchSize;
    private final DefectUpdateStatisticsService defectUpdateStatisticsService;

    @Autowired
    public AnalyzerServiceImpl(@Value(value="${rp.environment.variable.item-analyze.batch-size}") Integer itemsBatchSize, AnalyzerStatusCache analyzerStatusCache, LaunchPreparerService launchPreparerService, AnalyzerServiceClient analyzerServicesClient, IssueTypeHandler issueTypeHandler, TestItemRepository testItemRepository, MessageBus messageBus, LaunchRepository launchRepository, DefectUpdateStatisticsService defectUpdateStatisticsService) {
        this.itemsBatchSize = itemsBatchSize;
        this.analyzerStatusCache = analyzerStatusCache;
        this.launchPreparerService = launchPreparerService;
        this.analyzerServicesClient = analyzerServicesClient;
        this.issueTypeHandler = issueTypeHandler;
        this.testItemRepository = testItemRepository;
        this.messageBus = messageBus;
        this.launchRepository = launchRepository;
        this.defectUpdateStatisticsService = defectUpdateStatisticsService;
    }

    @Override
    public boolean hasAnalyzers() {
        return this.analyzerServicesClient.hasClients();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runAnalyzers(Launch launch, List<Long> testItemIds, AnalyzerConfig analyzerConfig) {
        try {
            this.analyzerStatusCache.analyzeStarted("autoAnalyzer", launch.getId(), launch.getProjectId());
            Optional<Long> previousLaunchId = this.findPreviousLaunchId(launch, analyzerConfig);
            Iterables.partition(testItemIds, (int)this.itemsBatchSize).forEach(partition -> this.analyzeItemsPartition(launch, (List<Long>)partition, analyzerConfig, previousLaunchId));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.analyzerStatusCache.analyzeFinished("autoAnalyzer", launch.getId());
        }
    }

    private void analyzeItemsPartition(Launch launch, List<Long> testItemIds, AnalyzerConfig analyzerConfig, Optional<Long> previousLaunchId) {
        LOGGER.info("Start analysis of '{}' items for launch with id '{}'", (Object)testItemIds.size(), (Object)launch.getId());
        List toAnalyze = this.testItemRepository.findAllById(testItemIds);
        Optional<IndexLaunch> rqLaunch = this.launchPreparerService.prepare(launch, toAnalyze, analyzerConfig);
        rqLaunch.ifPresent(rq -> {
            int amountToAnalyze = rq.getTestItems().size();
            previousLaunchId.ifPresent(arg_0 -> ((IndexLaunch)rq).setPreviousLaunchId(arg_0));
            Map<String, List<AnalyzedItemRs>> analyzedMap = this.analyzerServicesClient.analyze((IndexLaunch)rq);
            if (!MapUtils.isEmpty(analyzedMap)) {
                analyzedMap.forEach((key, value) -> this.updateTestItems((String)key, (List<AnalyzedItemRs>)value, toAnalyze, launch.getProjectId()));
            }
            int skipped = (int)toAnalyze.stream().filter(ti -> ti.getItemResults().getStatus().equals((Object)StatusEnum.SKIPPED)).count();
            int analyzedAmount = (int)analyzedMap.values().stream().mapToLong(Collection::size).sum();
            this.defectUpdateStatisticsService.saveAutoAnalyzedDefectStatistics(amountToAnalyze, analyzedAmount, skipped, rq.getProjectId());
        });
    }

    private List<TestItem> updateTestItems(String analyzerInstance, List<AnalyzedItemRs> rs, List<TestItem> testItems, Long projectId) {
        return rs.stream().map(analyzed -> {
            Optional<TestItem> toUpdate = testItems.stream().filter(item -> item.getItemId().equals(analyzed.getItemId())).findAny();
            toUpdate.ifPresent(testItem -> {
                LOGGER.debug("Analysis has found a match: {}", analyzed);
                if (!testItem.getItemResults().getIssue().getIssueType().getLocator().equals(analyzed.getLocator())) {
                    TestItemActivityResource before = TestItemConverter.TO_ACTIVITY_RESOURCE.apply((TestItem)testItem, projectId);
                    RelevantItemInfo relevantItemInfo = this.updateTestItemIssue(projectId, (AnalyzedItemRs)analyzed, (TestItem)testItem);
                    TestItemActivityResource after = TestItemConverter.TO_ACTIVITY_RESOURCE.apply((TestItem)testItem, projectId);
                    this.testItemRepository.save(testItem);
                    this.messageBus.publishActivity(new ItemIssueTypeDefinedEvent(before, after, analyzerInstance, relevantItemInfo));
                    Optional.ofNullable(after.getTickets()).ifPresent(it -> this.messageBus.publishActivity(new LinkTicketEvent(before, after, analyzerInstance, true)));
                }
            });
            return toUpdate;
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private RelevantItemInfo updateTestItemIssue(Long projectId, AnalyzedItemRs rs, TestItem testItem) {
        IssueType issueType = this.issueTypeHandler.defineIssueType(projectId, rs.getLocator());
        IssueEntity issueEntity = new IssueEntityBuilder(testItem.getItemResults().getIssue()).addIssueType(issueType).addIgnoreFlag(testItem.getItemResults().getIssue().getIgnoreAnalyzer()).addAutoAnalyzedFlag(true).get();
        issueEntity.setIssueId(testItem.getItemId());
        issueEntity.setTestItemResults(testItem.getItemResults());
        testItem.getItemResults().setIssue(issueEntity);
        RelevantItemInfo relevantItemInfo = null;
        if (rs.getRelevantItemId() != null) {
            Optional relevantItemOptional = this.testItemRepository.findById((Object)rs.getRelevantItemId());
            if (relevantItemOptional.isPresent()) {
                relevantItemInfo = this.updateIssueFromRelevantItem(issueEntity, (TestItem)relevantItemOptional.get());
            } else {
                LOGGER.error(ErrorType.TEST_ITEM_NOT_FOUND.getDescription(), (Object)rs.getRelevantItemId());
            }
        }
        return relevantItemInfo;
    }

    private RelevantItemInfo updateIssueFromRelevantItem(IssueEntity issue, TestItem relevantItem) {
        Optional.ofNullable(relevantItem.getItemResults().getIssue()).ifPresent(relevantIssue -> {
            issue.setIssueDescription(relevantIssue.getIssueDescription());
            issue.setTickets((Set)Sets.newHashSet((Iterable)relevantIssue.getTickets()));
        });
        return AnalyzerUtils.TO_RELEVANT_ITEM_INFO.apply(relevantItem);
    }

    private Optional<Long> findPreviousLaunchId(Launch launch, AnalyzerConfig analyzerConfig) {
        if (analyzerConfig.getAnalyzerMode().equals(AnalyzeMode.PREVIOUS_LAUNCH.getValue())) {
            return this.launchRepository.findPreviousLaunchId(launch);
        }
        return Optional.empty();
    }
}

