/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.client.impl;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.core.analyzer.auto.client.RabbitMqManagementClient;
import com.epam.ta.reportportal.core.analyzer.auto.client.impl.AnalyzerUtils;
import com.rabbitmq.http.client.Client;
import com.rabbitmq.http.client.domain.ExchangeInfo;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class RabbitMqManagementClientTemplate
implements RabbitMqManagementClient {
    private final Client rabbitClient;
    private final String virtualHost;

    public RabbitMqManagementClientTemplate(Client rabbitClient, String virtualHost) {
        this.rabbitClient = rabbitClient;
        this.virtualHost = virtualHost;
        try {
            rabbitClient.createVhost(virtualHost);
        }
        catch (Exception e) {
            throw new ReportPortalException(ErrorType.UNCLASSIFIED_REPORT_PORTAL_ERROR, new Object[]{"Unable to create RabbitMq virtual host"});
        }
    }

    @Override
    public List<ExchangeInfo> getAnalyzerExchangesInfo() {
        List client = this.rabbitClient.getExchanges(this.virtualHost);
        if (client == null) {
            throw new ReportPortalException(ErrorType.ANALYZER_NOT_FOUND, new Object[]{this.virtualHost});
        }
        return client.stream().filter(it -> it.getArguments().get("analyzer") != null).sorted(Comparator.comparingInt(AnalyzerUtils.EXCHANGE_PRIORITY)).collect(Collectors.toList());
    }
}

