/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.client.impl;

import com.epam.reportportal.model.analyzer.IndexLaunch;
import com.epam.ta.reportportal.core.analyzer.auto.client.IndexerServiceClient;
import com.epam.ta.reportportal.core.analyzer.auto.client.RabbitMqManagementClient;
import com.epam.ta.reportportal.core.analyzer.auto.client.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.analyzer.auto.client.model.IndexDefectsUpdate;
import com.epam.ta.reportportal.core.analyzer.auto.client.model.IndexItemsRemove;
import com.epam.ta.reportportal.core.analyzer.auto.client.model.IndexLaunchRemove;
import com.epam.ta.reportportal.model.analyzer.CleanIndexRq;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;

@Service
public class IndexerServiceClientImpl
implements IndexerServiceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexerServiceClient.class);
    private static final String INDEX_ROUTE = "index";
    static final String DEFECT_UPDATE_ROUTE = "defect_update";
    static final String ITEM_REMOVE_ROUTE = "item_remove";
    static final String LAUNCH_REMOVE_ROUTE = "launch_remove";
    private static final String NAMESPACE_FINDER_ROUTE = "namespace_finder";
    static final String DELETE_ROUTE = "delete";
    private static final String CLEAN_ROUTE = "clean";
    private static final Integer DELETE_INDEX_SUCCESS_CODE = 1;
    private final RabbitMqManagementClient rabbitMqManagementClient;
    private final RabbitTemplate rabbitTemplate;

    public IndexerServiceClientImpl(RabbitMqManagementClient rabbitMqManagementClient, @Qualifier(value="analyzerRabbitTemplate") RabbitTemplate rabbitTemplate) {
        this.rabbitMqManagementClient = rabbitMqManagementClient;
        this.rabbitTemplate = rabbitTemplate;
    }

    @Override
    public void index(List<IndexLaunch> rq) {
        this.rabbitMqManagementClient.getAnalyzerExchangesInfo().stream().filter(AnalyzerUtils.DOES_SUPPORT_INDEX).forEach(exchange -> {
            this.rabbitTemplate.convertAndSend(exchange.getName(), NAMESPACE_FINDER_ROUTE, (Object)rq);
            this.rabbitTemplate.convertAndSend(exchange.getName(), INDEX_ROUTE, (Object)rq);
        });
    }

    @Override
    public List<Long> indexDefectsUpdate(Long projectId, Map<Long, String> itemsForIndexUpdate) {
        return this.rabbitMqManagementClient.getAnalyzerExchangesInfo().stream().filter(AnalyzerUtils.DOES_SUPPORT_INDEX).flatMap(exchange -> Optional.ofNullable((List)this.rabbitTemplate.convertSendAndReceiveAsType(exchange.getName(), DEFECT_UPDATE_ROUTE, (Object)new IndexDefectsUpdate(projectId, itemsForIndexUpdate), (ParameterizedTypeReference)new ParameterizedTypeReference<List<Long>>(this){})).orElse(Collections.emptyList()).stream()).collect(Collectors.toList());
    }

    @Override
    public Integer indexItemsRemove(Long projectId, Collection<Long> itemsForIndexRemove) {
        return this.rabbitMqManagementClient.getAnalyzerExchangesInfo().stream().filter(AnalyzerUtils.DOES_SUPPORT_INDEX).map(exchange -> Optional.ofNullable((Integer)this.rabbitTemplate.convertSendAndReceiveAsType(exchange.getName(), ITEM_REMOVE_ROUTE, (Object)new IndexItemsRemove(projectId, itemsForIndexRemove), (ParameterizedTypeReference)new ParameterizedTypeReference<Integer>(this){})).orElse(0)).mapToInt(Integer::intValue).sum();
    }

    @Override
    public void indexItemsRemoveAsync(Long projectId, Collection<Long> itemsForIndexRemove) {
        this.rabbitMqManagementClient.getAnalyzerExchangesInfo().stream().filter(AnalyzerUtils.DOES_SUPPORT_INDEX).forEach(exchange -> this.rabbitTemplate.convertAndSend(exchange.getName(), ITEM_REMOVE_ROUTE, (Object)new IndexItemsRemove(projectId, itemsForIndexRemove)));
    }

    @Override
    public void indexLaunchesRemove(Long projectId, Collection<Long> launchesForIndexRemove) {
        this.rabbitMqManagementClient.getAnalyzerExchangesInfo().stream().filter(AnalyzerUtils.DOES_SUPPORT_INDEX).forEach(exchange -> this.rabbitTemplate.convertAndSend(exchange.getName(), LAUNCH_REMOVE_ROUTE, (Object)new IndexLaunchRemove(projectId, launchesForIndexRemove)));
    }

    @Override
    public Long cleanIndex(Long index, List<Long> ids) {
        Map<Integer, Long> priorityToCleanedLogsCountMapping = this.rabbitMqManagementClient.getAnalyzerExchangesInfo().stream().collect(Collectors.toMap(AnalyzerUtils.EXCHANGE_PRIORITY::applyAsInt, exchange -> (Long)this.rabbitTemplate.convertSendAndReceiveAsType(exchange.getName(), CLEAN_ROUTE, (Object)new CleanIndexRq(index, ids), (ParameterizedTypeReference)new ParameterizedTypeReference<Long>(this){})));
        return (Long)priorityToCleanedLogsCountMapping.entrySet().stream().min(Map.Entry.comparingByKey()).orElseGet(() -> new AbstractMap.SimpleEntry<Integer, Long>(0, 0L)).getValue();
    }

    @Override
    public void deleteIndex(Long index) {
        this.rabbitMqManagementClient.getAnalyzerExchangesInfo().stream().map(exchange -> (Integer)this.rabbitTemplate.convertSendAndReceiveAsType(exchange.getName(), DELETE_ROUTE, (Object)index, (ParameterizedTypeReference)new ParameterizedTypeReference<Integer>(this){})).forEach(it -> {
            if (DELETE_INDEX_SUCCESS_CODE.equals(it)) {
                LOGGER.info("Successfully deleted index '{}'", (Object)index);
            } else {
                LOGGER.error("Error deleting index '{}'", (Object)index);
            }
        });
    }
}

