/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.admin;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.admin.ServerAdminHandler;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.SettingsUpdatedEvent;
import com.epam.ta.reportportal.dao.ServerSettingsRepository;
import com.epam.ta.reportportal.entity.ServerSettings;
import com.epam.ta.reportportal.model.settings.AnalyticsResource;
import com.epam.ta.reportportal.model.settings.ServerSettingsResource;
import com.epam.ta.reportportal.model.settings.UpdateSettingsRq;
import com.epam.ta.reportportal.ws.converter.converters.ServerSettingsConverter;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ServerAdminHandlerImpl
implements ServerAdminHandler {
    private final ServerSettingsRepository serverSettingsRepository;
    private final MessageBus messageBus;

    @Override
    public Map<String, String> getServerSettings() {
        return ServerSettingsConverter.TO_RESOURCES.apply(this.serverSettingsRepository.selectServerSettings());
    }

    @Override
    public OperationCompletionRS saveAnalyticsSettings(AnalyticsResource analyticsResource) {
        String analyticsType = analyticsResource.getType();
        Map<String, ServerSettings> serverAnalyticsDetails = this.findServerSettings().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("server.analytics.")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Object formattedAnalyticsType = analyticsType.startsWith("server.analytics.") ? analyticsType : "server.analytics." + analyticsType;
        ServerSettings analyticsDetails = Optional.ofNullable(serverAnalyticsDetails.get(formattedAnalyticsType)).orElseGet(ServerSettings::new);
        analyticsDetails.setKey((String)formattedAnalyticsType);
        analyticsDetails.setValue(String.valueOf(Optional.ofNullable(analyticsResource.getEnabled()).orElse(false)));
        this.serverSettingsRepository.save((Object)analyticsDetails);
        return new OperationCompletionRS("Server Settings were successfully updated.");
    }

    @Override
    public OperationCompletionRS updateServerSettings(UpdateSettingsRq request, ReportPortalUser user) {
        ServerSettings serverSettings = (ServerSettings)this.serverSettingsRepository.findByKey(request.getKey()).orElseThrow(() -> new ReportPortalException(ErrorType.SERVER_SETTINGS_NOT_FOUND, new Object[]{request.getKey()}));
        ServerSettingsResource before = ServerSettingsConverter.TO_RESOURCE.apply(serverSettings);
        serverSettings.setValue(request.getValue());
        this.serverSettingsRepository.save((Object)serverSettings);
        this.messageBus.publishActivity(new SettingsUpdatedEvent(before, ServerSettingsConverter.TO_RESOURCE.apply(serverSettings), user.getUserId(), user.getUsername()));
        return new OperationCompletionRS("Server Settings were successfully updated.");
    }

    private Map<String, ServerSettings> findServerSettings() {
        return this.serverSettingsRepository.selectServerSettings().stream().collect(Collectors.toMap(ServerSettings::getKey, s -> s, (prev, curr) -> prev));
    }

    @Generated
    public ServerAdminHandlerImpl(ServerSettingsRepository serverSettingsRepository, MessageBus messageBus) {
        this.serverSettingsRepository = serverSettingsRepository;
        this.messageBus = messageBus;
    }
}

