/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.activity.impl;

import com.epam.reportportal.model.ActivityResource;
import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.CompositeFilter;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.FilterTarget;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.activity.ActivityHandler;
import com.epam.ta.reportportal.dao.ActivityRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.entity.activity.EventAction;
import com.epam.ta.reportportal.entity.activity.EventObject;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.model.ActivityEventResource;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.converters.ActivityConverter;
import com.epam.ta.reportportal.ws.converter.converters.ActivityEventConverter;
import java.util.function.Predicate;
import org.apache.commons.lang3.BooleanUtils;
import org.jooq.Operator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ActivityHandlerImpl
implements ActivityHandler {
    private final ActivityRepository activityRepository;
    private final TestItemRepository testItemRepository;
    private final LaunchRepository launchRepository;
    private final ProjectRepository projectRepository;

    @Autowired
    public ActivityHandlerImpl(ActivityRepository activityRepository, TestItemRepository testItemRepository, LaunchRepository launchRepository, ProjectRepository projectRepository) {
        this.activityRepository = activityRepository;
        this.testItemRepository = testItemRepository;
        this.launchRepository = launchRepository;
        this.projectRepository = projectRepository;
    }

    @Override
    public Iterable<ActivityResource> getActivitiesHistory(ReportPortalUser.ProjectDetails projectDetails, Filter filter, Queryable predefinedFilter, Pageable pageable) {
        BusinessRule.expect((Object)this.projectRepository.existsById((Object)projectDetails.getProjectId()), BooleanUtils::isTrue).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectDetails.getProjectId()});
        FilterCondition projectCondition = FilterCondition.builder().eq("projectId", String.valueOf(projectDetails.getProjectId())).build();
        Page page = this.activityRepository.findByFilter((Queryable)new CompositeFilter(Operator.AND, new Queryable[]{filter.withCondition((ConvertibleCondition)projectCondition), predefinedFilter}), pageable);
        return PagedResourcesAssembler.pageConverter(ActivityConverter.TO_RESOURCE).apply((Page<Activity>)page);
    }

    @Override
    public ActivityResource getActivity(ReportPortalUser.ProjectDetails projectDetails, Long activityId) {
        Activity activity = (Activity)this.activityRepository.findById((Object)activityId).orElseThrow(() -> new ReportPortalException(ErrorType.ACTIVITY_NOT_FOUND, new Object[]{activityId}));
        BusinessRule.expect((Object)projectDetails.getProjectId(), Predicate.isEqual(activity.getProjectId())).verify(ErrorType.ACCESS_DENIED, new Object[]{Suppliers.formattedSupplier((String)"Activity with id '{}' is not under project with id '{}'", (Object[])new Object[]{activityId, projectDetails.getProjectId()})});
        return ActivityConverter.TO_RESOURCE.apply(activity);
    }

    @Override
    public com.epam.ta.reportportal.model.Page<ActivityEventResource> getItemActivities(ReportPortalUser.ProjectDetails projectDetails, Long itemId, Filter filter, Pageable pageable) {
        TestItem testItem = (TestItem)this.testItemRepository.findById((Object)itemId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{itemId}));
        Launch launch = (Launch)this.launchRepository.findById((Object)testItem.getLaunchId()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{testItem.getLaunchId()}));
        BusinessRule.expect((Object)projectDetails.getProjectId(), Predicate.isEqual(launch.getProjectId())).verify(ErrorType.ACCESS_DENIED, new Object[]{Suppliers.formattedSupplier((String)"Test item with id '{}' is not under project with id '{}'", (Object[])new Object[]{itemId, projectDetails.getProjectId()})});
        Sort sortByCreationDateDesc = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createdAt"});
        Filter patternActivityFilter = this.buildPatternMatchedActivityFilter(filter.getTarget(), itemId).withConditions(filter.getFilterConditions());
        filter.withCondition((ConvertibleCondition)FilterCondition.builder().eq("objectId", String.valueOf(itemId)).build()).withCondition((ConvertibleCondition)FilterCondition.builder().withSearchCriteria("objectType").withCondition(Condition.IN).withValue(EventObject.ITEM_ISSUE.toString()).build());
        Page page = this.activityRepository.findByFilter((Queryable)new CompositeFilter(Operator.OR, new Queryable[]{filter, patternActivityFilter}), (Pageable)PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)sortByCreationDateDesc));
        return PagedResourcesAssembler.pageConverter(ActivityEventConverter.TO_RESOURCE).apply((Page<Activity>)page);
    }

    @Override
    public Iterable<ActivityResource> getItemActivities(ReportPortalUser.ProjectDetails projectDetails, Filter filter, Pageable pageable) {
        BusinessRule.expect((Object)this.projectRepository.existsById((Object)projectDetails.getProjectId()), BooleanUtils::isTrue).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectDetails.getProjectId()});
        filter.withCondition((ConvertibleCondition)FilterCondition.builder().eq("projectId", String.valueOf(projectDetails.getProjectId())).build());
        return PagedResourcesAssembler.pageConverter(ActivityConverter.TO_RESOURCE).apply((Page<Activity>)this.activityRepository.findByFilter((Queryable)filter, pageable));
    }

    private Filter buildPatternMatchedActivityFilter(FilterTarget filterTarget, Long itemId) {
        return Filter.builder().withTarget(filterTarget.getClazz()).withCondition((ConvertibleCondition)FilterCondition.builder().eq("objectId", String.valueOf(itemId)).build()).withCondition((ConvertibleCondition)FilterCondition.builder().eq("objectType", EventObject.PATTERN.toString()).build()).withCondition((ConvertibleCondition)FilterCondition.builder().eq("action", EventAction.MATCH.toString()).build()).build();
    }
}

