/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.auth.permissions;

import com.epam.ta.reportportal.auth.permissions.Permission;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.exception.PermissionNotDefinedException;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Map;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

class ReportPortalPermissionEvaluator
implements PermissionEvaluator {
    private static final GrantedAuthority ADMIN_AUTHORITY = new SimpleGrantedAuthority(UserRole.ADMINISTRATOR.getAuthority());
    private Map<String, Permission> permissionNameToPermissionMap;
    private boolean allowAllToAdmin;

    public ReportPortalPermissionEvaluator(Map<String, Permission> permissionNameToPermissionMap) {
        this(permissionNameToPermissionMap, true);
    }

    public ReportPortalPermissionEvaluator(Map<String, Permission> permissionNameToPermissionMap, boolean allowAllToAdmin) {
        this.permissionNameToPermissionMap = (Map)Preconditions.checkNotNull(permissionNameToPermissionMap);
        this.allowAllToAdmin = allowAllToAdmin;
    }

    public boolean hasPermission(Authentication authentication, Object targetDomainObject, Object permission) {
        boolean hasPermission = false;
        if (this.canHandle(authentication, targetDomainObject, permission)) {
            hasPermission = this.checkPermission(authentication, targetDomainObject, (String)permission);
        }
        return hasPermission;
    }

    private boolean canHandle(Authentication authentication, Object targetDomainObject, Object permission) {
        return targetDomainObject != null && authentication != null && String.class.equals(permission.getClass());
    }

    private boolean checkPermission(Authentication authentication, Object targetDomainObject, String permissionKey) {
        this.verifyPermissionIsDefined(permissionKey);
        if (this.allowAllToAdmin && authentication.isAuthenticated() && authentication.getAuthorities().contains(ADMIN_AUTHORITY)) {
            return true;
        }
        Permission permission = this.permissionNameToPermissionMap.get(permissionKey);
        return permission.isAllowed(authentication, targetDomainObject);
    }

    private void verifyPermissionIsDefined(String permissionKey) {
        if (!this.permissionNameToPermissionMap.containsKey(permissionKey)) {
            throw new PermissionNotDefinedException("No permission with key " + permissionKey + " is defined in " + this.getClass().toString());
        }
    }

    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permission) {
        throw new PermissionNotDefinedException("Id and Class permissions are not supported by " + String.valueOf(this.getClass()));
    }
}

