/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.api.model;

import com.epam.reportportal.api.model.ProjectGroupInfoStats;
import com.epam.reportportal.api.model.ProjectRole;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.lang.Nullable;

@Schema(name="ProjectGroupInfo", description="Information about project group.")
public class ProjectGroupInfo {
    @Nullable
    private Long id;
    @Nullable
    private UUID uuid;
    @Nullable
    private String name;
    @Nullable
    private String slug;
    private ProjectRole permission = ProjectRole.MEMBER;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Nullable
    private Instant addedAt;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Nullable
    private Instant updatedAt;
    @Nullable
    private ProjectGroupInfoStats stats;

    public ProjectGroupInfo() {
    }

    public ProjectGroupInfo(@Nullable Long id, @Nullable UUID uuid, @Nullable String name, @Nullable String slug, ProjectRole permission, @Nullable Instant addedAt, @Nullable Instant updatedAt, @Nullable ProjectGroupInfoStats stats) {
        this.id = id;
        this.uuid = uuid;
        this.name = name;
        this.slug = slug;
        this.permission = permission;
        this.addedAt = addedAt;
        this.updatedAt = updatedAt;
        this.stats = stats;
    }

    public ProjectGroupInfo id(Long id) {
        this.id = id;
        return this;
    }

    @Min(value=1L)
    @Schema(name="id", description="Resource identifier.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public @Min(value=1L) Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ProjectGroupInfo uuid(UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    @Valid
    @Schema(name="uuid", description="Group identifier for external usage.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="uuid")
    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public ProjectGroupInfo name(String name) {
        this.name = name;
        return this;
    }

    @Pattern(regexp="^[A-Za-z0-9.'_\\- ]+$")
    @Size(min=3, max=60)
    @Schema(name="name", description="Display name.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="name")
    public @Pattern(regexp="^[A-Za-z0-9.'_\\- ]+$") @Size(min=3, max=60) String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProjectGroupInfo slug(String slug) {
        this.slug = slug;
        return this;
    }

    @Pattern(regexp="^[a-z0-9]+(?:-[a-z0-9]+)*$")
    @Size(min=3, max=60)
    @Schema(name="slug", description="A slug is used to identify a resource. It should be unique and contain only lowercase letters, numbers, and hyphens. It should not start or end with a hyphen.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="slug")
    public @Pattern(regexp="^[a-z0-9]+(?:-[a-z0-9]+)*$") @Size(min=3, max=60) String getSlug() {
        return this.slug;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public ProjectGroupInfo permission(ProjectRole permission) {
        this.permission = permission;
        return this;
    }

    @Valid
    @Schema(name="permission", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="permission")
    public ProjectRole getPermission() {
        return this.permission;
    }

    public void setPermission(ProjectRole permission) {
        this.permission = permission;
    }

    public ProjectGroupInfo addedAt(Instant addedAt) {
        this.addedAt = addedAt;
        return this;
    }

    @Valid
    @Schema(name="added_at", description="Timestamp of project adding to group.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="added_at")
    public Instant getAddedAt() {
        return this.addedAt;
    }

    public void setAddedAt(Instant addedAt) {
        this.addedAt = addedAt;
    }

    public ProjectGroupInfo updatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Valid
    @Schema(name="updated_at", description="Timestamp of project updating in group.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="updated_at")
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
    }

    public ProjectGroupInfo stats(ProjectGroupInfoStats stats) {
        this.stats = stats;
        return this;
    }

    @Valid
    @Schema(name="stats", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="stats")
    public ProjectGroupInfoStats getStats() {
        return this.stats;
    }

    public void setStats(ProjectGroupInfoStats stats) {
        this.stats = stats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectGroupInfo projectGroupInfo = (ProjectGroupInfo)o;
        return Objects.equals(this.id, projectGroupInfo.id) && Objects.equals(this.uuid, projectGroupInfo.uuid) && Objects.equals(this.name, projectGroupInfo.name) && Objects.equals(this.slug, projectGroupInfo.slug) && Objects.equals((Object)this.permission, (Object)projectGroupInfo.permission) && Objects.equals(this.addedAt, projectGroupInfo.addedAt) && Objects.equals(this.updatedAt, projectGroupInfo.updatedAt) && Objects.equals(this.stats, projectGroupInfo.stats);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.uuid, this.name, this.slug, this.permission, this.addedAt, this.updatedAt, this.stats});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectGroupInfo {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    slug: ").append(this.toIndentedString(this.slug)).append("\n");
        sb.append("    permission: ").append(this.toIndentedString((Object)this.permission)).append("\n");
        sb.append("    addedAt: ").append(this.toIndentedString(this.addedAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    stats: ").append(this.toIndentedString(this.stats)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        return builder.copyOf(this);
    }

    public static class Builder {
        private ProjectGroupInfo instance;

        public Builder() {
            this(new ProjectGroupInfo());
        }

        protected Builder(ProjectGroupInfo instance) {
            this.instance = instance;
        }

        protected Builder copyOf(ProjectGroupInfo value) {
            this.instance.setId(value.id);
            this.instance.setUuid(value.uuid);
            this.instance.setName(value.name);
            this.instance.setSlug(value.slug);
            this.instance.setPermission(value.permission);
            this.instance.setAddedAt(value.addedAt);
            this.instance.setUpdatedAt(value.updatedAt);
            this.instance.setStats(value.stats);
            return this;
        }

        public Builder id(Long id) {
            this.instance.id(id);
            return this;
        }

        public Builder uuid(UUID uuid) {
            this.instance.uuid(uuid);
            return this;
        }

        public Builder name(String name) {
            this.instance.name(name);
            return this;
        }

        public Builder slug(String slug) {
            this.instance.slug(slug);
            return this;
        }

        public Builder permission(ProjectRole permission) {
            this.instance.permission(permission);
            return this;
        }

        public Builder addedAt(Instant addedAt) {
            this.instance.addedAt(addedAt);
            return this;
        }

        public Builder updatedAt(Instant updatedAt) {
            this.instance.updatedAt(updatedAt);
            return this;
        }

        public Builder stats(ProjectGroupInfoStats stats) {
            this.instance.stats(stats);
            return this;
        }

        public ProjectGroupInfo build() {
            try {
                ProjectGroupInfo projectGroupInfo = this.instance;
                return projectGroupInfo;
            }
            finally {
                this.instance = null;
            }
        }

        public String toString() {
            return String.valueOf(this.getClass()) + "=(" + String.valueOf(this.instance) + ")";
        }
    }
}

