/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.Objects;
import org.springframework.lang.Nullable;

@Schema(name="Problem", description="Problem Details for HTTP APIs [RFC 9457](https://tools.ietf.org/html/rfc9457).  A Problem JSON object uses the media type `application/problem+json`.")
public class Problem {
    private String type = "about:blank";
    @Nullable
    private String title;
    @Nullable
    private Integer status;
    @Nullable
    private String detail;
    @Nullable
    private String instance;

    public Problem() {
    }

    public Problem(String type, @Nullable String title, @Nullable Integer status, @Nullable String detail, @Nullable String instance) {
        this.type = type;
        this.title = title;
        this.status = status;
        this.detail = detail;
        this.instance = instance;
    }

    public Problem type(String type) {
        this.type = type;
        return this;
    }

    @Schema(name="type", example="/problems/user-authorization-failed", description="A URI reference that uniquely identifies the problem type only in the context of the provided API. Opposed to the specification in RFC-9457, it is neither recommended to be dereferenceable and point to a human-readable documentation nor globally unique for the problem type. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Problem title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", example="some title for the error situation", description="A short summary of the problem type. Written in English and readable for engineers, usually not suited for non technical stakeholders and not localized. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Problem status(Integer status) {
        this.status = status;
        return this;
    }

    @Min(value=100L)
    @Max(value=600L)
    @Schema(name="status", description="The HTTP status code generated by the origin server for this occurrence of the problem. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="status")
    public @Min(value=100L) @Max(value=600L) Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Problem detail(String detail) {
        this.detail = detail;
        return this;
    }

    @Schema(name="detail", example="some description for the error situation", description="A human readable explanation specific to this occurrence of the problem that is helpful to locate the problem and give advice on how to proceed. Written in English and readable for engineers, usually not suited for non technical stakeholders and not localized. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="detail")
    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Problem instance(String instance) {
        this.instance = instance;
        return this;
    }

    @Schema(name="instance", example="/some/uri-reference#specific-occurrence-context", description="A URI reference that identifies the specific occurrence of the problem, e.g. by adding a fragment identifier or sub-path to the problem type. May be used to locate the root of this problem in the source code. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="instance")
    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Problem problem = (Problem)o;
        return Objects.equals(this.type, problem.type) && Objects.equals(this.title, problem.title) && Objects.equals(this.status, problem.status) && Objects.equals(this.detail, problem.detail) && Objects.equals(this.instance, problem.instance);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.title, this.status, this.detail, this.instance);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Problem {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        sb.append("    instance: ").append(this.toIndentedString(this.instance)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        return builder.copyOf(this);
    }

    public static class Builder {
        private Problem instance;

        public Builder() {
            this(new Problem());
        }

        protected Builder(Problem instance) {
            this.instance = instance;
        }

        protected Builder copyOf(Problem value) {
            this.instance.setType(value.type);
            this.instance.setTitle(value.title);
            this.instance.setStatus(value.status);
            this.instance.setDetail(value.detail);
            this.instance.setInstance(value.instance);
            return this;
        }

        public Builder type(String type) {
            this.instance.type(type);
            return this;
        }

        public Builder title(String title) {
            this.instance.title(title);
            return this;
        }

        public Builder status(Integer status) {
            this.instance.status(status);
            return this;
        }

        public Builder detail(String detail) {
            this.instance.detail(detail);
            return this;
        }

        public Builder instance(String instance) {
            this.instance.instance(instance);
            return this;
        }

        public Problem build() {
            try {
                Problem problem = this.instance;
                return problem;
            }
            finally {
                this.instance = null;
            }
        }

        public String toString() {
            return String.valueOf(this.getClass()) + "=(" + String.valueOf(this.instance) + ")";
        }
    }
}

