/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.api.model;

import com.epam.reportportal.api.model.GroupProjectInfo;
import com.epam.reportportal.api.model.Offset;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.data.domain.Sort;
import org.springframework.lang.Nullable;

@Schema(name="GroupProjectsPage", description="Page of group projects.")
public class GroupProjectsPage
extends Offset {
    @Valid
    private @Valid List<@Valid GroupProjectInfo> items = new ArrayList<GroupProjectInfo>();

    public GroupProjectsPage() {
    }

    public GroupProjectsPage(List<@Valid GroupProjectInfo> items, Integer offset, Integer limit, @Nullable Integer totalCount, @Nullable String sort, @Nullable Sort.Direction order) {
        super(offset, limit, totalCount, sort, order);
        this.items = items;
    }

    public GroupProjectsPage items(List<@Valid GroupProjectInfo> items) {
        this.items = items;
        return this;
    }

    public GroupProjectsPage addItemsItem(GroupProjectInfo itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<GroupProjectInfo>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Valid
    @Schema(name="items", description="List of group projects.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="items")
    public @Valid List<@Valid GroupProjectInfo> getItems() {
        return this.items;
    }

    public void setItems(List<@Valid GroupProjectInfo> items) {
        this.items = items;
    }

    @Override
    public GroupProjectsPage offset(Integer offset) {
        super.offset(offset);
        return this;
    }

    @Override
    public GroupProjectsPage limit(Integer limit) {
        super.limit(limit);
        return this;
    }

    @Override
    public GroupProjectsPage totalCount(Integer totalCount) {
        super.totalCount(totalCount);
        return this;
    }

    @Override
    public GroupProjectsPage sort(String sort) {
        super.sort(sort);
        return this;
    }

    @Override
    public GroupProjectsPage order(Sort.Direction order) {
        super.order(order);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupProjectsPage groupProjectsPage = (GroupProjectsPage)o;
        return Objects.equals(this.items, groupProjectsPage.items) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.items, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupProjectsPage {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        return builder.copyOf(this);
    }

    public static class Builder
    extends Offset.Builder {
        private GroupProjectsPage instance;

        public Builder() {
            this(new GroupProjectsPage());
        }

        protected Builder(GroupProjectsPage instance) {
            super(instance);
            this.instance = instance;
        }

        protected Builder copyOf(GroupProjectsPage value) {
            super.copyOf(value);
            this.instance.setItems(value.items);
            return this;
        }

        public Builder items(List<GroupProjectInfo> items) {
            this.instance.items(items);
            return this;
        }

        @Override
        public Builder offset(Integer offset) {
            this.instance.offset(offset);
            return this;
        }

        @Override
        public Builder limit(Integer limit) {
            this.instance.limit(limit);
            return this;
        }

        @Override
        public Builder totalCount(Integer totalCount) {
            this.instance.totalCount(totalCount);
            return this;
        }

        @Override
        public Builder sort(String sort) {
            this.instance.sort(sort);
            return this;
        }

        @Override
        public Builder order(Sort.Direction order) {
            this.instance.order(order);
            return this;
        }

        @Override
        public GroupProjectsPage build() {
            try {
                GroupProjectsPage groupProjectsPage = this.instance;
                return groupProjectsPage;
            }
            finally {
                super.build();
                this.instance = null;
            }
        }

        @Override
        public String toString() {
            return String.valueOf(this.getClass()) + "=(" + String.valueOf(this.instance) + ")";
        }
    }
}

