/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.api.model;

import com.epam.reportportal.api.model.GroupInfo;
import com.epam.reportportal.api.model.Offset;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.data.domain.Sort;
import org.springframework.lang.Nullable;

@Schema(name="GroupPage", description="Page of groups.")
public class GroupPage
extends Offset {
    @Valid
    private @Valid List<@Valid GroupInfo> items = new ArrayList<GroupInfo>();

    public GroupPage() {
    }

    public GroupPage(List<@Valid GroupInfo> items, Integer offset, Integer limit, @Nullable Integer totalCount, @Nullable String sort, @Nullable Sort.Direction order) {
        super(offset, limit, totalCount, sort, order);
        this.items = items;
    }

    public GroupPage items(List<@Valid GroupInfo> items) {
        this.items = items;
        return this;
    }

    public GroupPage addItemsItem(GroupInfo itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<GroupInfo>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Valid
    @Schema(name="items", description="List of groups.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="items")
    public @Valid List<@Valid GroupInfo> getItems() {
        return this.items;
    }

    public void setItems(List<@Valid GroupInfo> items) {
        this.items = items;
    }

    @Override
    public GroupPage offset(Integer offset) {
        super.offset(offset);
        return this;
    }

    @Override
    public GroupPage limit(Integer limit) {
        super.limit(limit);
        return this;
    }

    @Override
    public GroupPage totalCount(Integer totalCount) {
        super.totalCount(totalCount);
        return this;
    }

    @Override
    public GroupPage sort(String sort) {
        super.sort(sort);
        return this;
    }

    @Override
    public GroupPage order(Sort.Direction order) {
        super.order(order);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupPage groupPage = (GroupPage)o;
        return Objects.equals(this.items, groupPage.items) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.items, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupPage {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        return builder.copyOf(this);
    }

    public static class Builder
    extends Offset.Builder {
        private GroupPage instance;

        public Builder() {
            this(new GroupPage());
        }

        protected Builder(GroupPage instance) {
            super(instance);
            this.instance = instance;
        }

        protected Builder copyOf(GroupPage value) {
            super.copyOf(value);
            this.instance.setItems(value.items);
            return this;
        }

        public Builder items(List<GroupInfo> items) {
            this.instance.items(items);
            return this;
        }

        @Override
        public Builder offset(Integer offset) {
            this.instance.offset(offset);
            return this;
        }

        @Override
        public Builder limit(Integer limit) {
            this.instance.limit(limit);
            return this;
        }

        @Override
        public Builder totalCount(Integer totalCount) {
            this.instance.totalCount(totalCount);
            return this;
        }

        @Override
        public Builder sort(String sort) {
            this.instance.sort(sort);
            return this;
        }

        @Override
        public Builder order(Sort.Direction order) {
            this.instance.order(order);
            return this;
        }

        @Override
        public GroupPage build() {
            try {
                GroupPage groupPage = this.instance;
                return groupPage;
            }
            finally {
                super.build();
                this.instance = null;
            }
        }

        @Override
        public String toString() {
            return String.valueOf(this.getClass()) + "=(" + String.valueOf(this.instance) + ")";
        }
    }
}

