/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum AccountType {
    INTERNAL("INTERNAL"),
    UPSA("UPSA"),
    GITHUB("GITHUB"),
    LDAP("LDAP"),
    SAML("SAML"),
    SCIM("SCIM");

    private String value;

    private AccountType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static AccountType fromValue(String value) {
        for (AccountType b : AccountType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
}

